/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.configs.SchedulerConfiguration;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.KeepLaunchDelay;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.job.LaunchCleanerService;
import com.epam.ta.reportportal.job.LogCleanerService;
import com.epam.ta.reportportal.job.PageUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CleanLaunchesJob
implements Job {
    public static final int DEFAULT_THREAD_COUNT = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLaunchesJob.class);
    private final ProjectRepository projectRepository;
    private final LogCleanerService logCleaner;
    private final SchedulerConfiguration.CleanLaunchesJobProperties cleanLaunchesJobProperties;
    private final LaunchCleanerService launchCleaner;
    @Value(value="5")
    private Integer threadsCount;

    @Autowired
    public CleanLaunchesJob(ProjectRepository projectRepository, LogCleanerService logCleaner, SchedulerConfiguration.CleanLaunchesJobProperties cleanLaunchesJobProperties, LaunchCleanerService launchCleaner) {
        this.projectRepository = projectRepository;
        this.logCleaner = logCleaner;
        this.cleanLaunchesJobProperties = cleanLaunchesJobProperties;
        this.launchCleaner = launchCleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Cleaning outdated logs has been started");
        ExecutorService executor = Executors.newFixedThreadPool(Optional.ofNullable(this.threadsCount).orElse(5), new ThreadFactoryBuilder().setNameFormat("clean-launches-job-thread-%d").build());
        PageUtil.iterateOverPages(pageable -> this.projectRepository.findAllIdsAndProjectAttributes((Queryable)this.buildProjectAttributesFilter(ProjectAttributeEnum.KEEP_LAUNCHES), pageable), projects -> projects.forEach(project -> {
            AtomicLong removedLaunchesCount = new AtomicLong(0L);
            AtomicLong removedAttachmentsCount = new AtomicLong(0L);
            AtomicLong removedThumbnailsCount = new AtomicLong(0L);
            executor.submit(() -> {
                try {
                    this.proceedLaunchesCleaning((Project)project, removedLaunchesCount, removedAttachmentsCount, removedThumbnailsCount);
                }
                catch (Exception e) {
                    LOGGER.error("Cleaning outdated launches for project {} has been failed", (Object)project.getId(), (Object)e);
                }
                if (removedLaunchesCount.get() > 0L || removedAttachmentsCount.get() > 0L || removedThumbnailsCount.get() > 0L) {
                    LOGGER.info("Cleaning outdated launches for project {} has been finished. Total launches removed: {}. Attachments removed: {}. Thumbnails removed: {}", new Object[]{project.getId(), removedLaunchesCount.get(), removedAttachmentsCount.get(), removedThumbnailsCount.get()});
                }
            });
        }));
        try {
            executor.shutdown();
            if (!executor.awaitTermination(this.cleanLaunchesJobProperties.getTimeout().intValue(), TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Waiting for launch removing tasks execution has been failed", (Throwable)e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private Filter buildProjectAttributesFilter(ProjectAttributeEnum projectAttributeEnum) {
        return Filter.builder().withTarget(Project.class).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, projectAttributeEnum.getAttribute(), "attributeName")).build();
    }

    private void proceedLaunchesCleaning(Project project, AtomicLong removedLaunchesCount, AtomicLong removedAttachmentsCount, AtomicLong removedThumbnailsCount) {
        project.getProjectAttributes().stream().filter(pa -> pa.getAttribute().getName().equalsIgnoreCase(ProjectAttributeEnum.KEEP_LAUNCHES.getAttribute())).findFirst().ifPresent(pa -> {
            KeepLaunchDelay delay = (KeepLaunchDelay)KeepLaunchDelay.findByName((String)pa.getValue()).orElseThrow(() -> new ReportPortalException("Incorrect keep launch delay period: " + pa.getValue()));
            Duration period = Duration.ofDays(delay.getDays());
            if (!period.isZero()) {
                this.logCleaner.removeProjectAttachments(project, period, removedAttachmentsCount, removedThumbnailsCount);
                this.launchCleaner.cleanOutdatedLaunches(project, period, removedLaunchesCount);
            }
        });
    }
}

