/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.util;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.ProductStatusContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductStatusContentLoaderManager
implements LoadContentStrategy {
    private final Map<String, ProductStatusContentLoader> productStatusContentLoader;

    @Autowired
    public ProductStatusContentLoaderManager(@Qualifier(value="productStatusContentLoader") Map<String, ProductStatusContentLoader> productStatusContentLoader) {
        this.productStatusContentLoader = productStatusContentLoader;
    }

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        String strategy = WidgetOptionUtil.getValueByKey("strategy", widgetOptions);
        return Optional.ofNullable(this.productStatusContentLoader.get(strategy)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Wrong strategy type. Allowed: \"filter\", \"launch\". But found: " + strategy})).loadContent(contentFields, filterSortMapping, widgetOptions, limit);
    }
}

