/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.entity.widget.content.AbstractLaunchStatisticsContent;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class AbstractStatisticsContentLoader {
    protected Map<String, ChartStatisticsContent> groupByDate(List<ChartStatisticsContent> input, Period period) {
        LongSummaryStatistics statistics = input.stream().mapToLong(object -> object.getStartTime().getTime()).summaryStatistics();
        DateTime start = new DateTime(statistics.getMin());
        DateTime end = new DateTime(statistics.getMax());
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, ChartStatisticsContent> chart = new LinkedHashMap<String, ChartStatisticsContent>();
        switch (period) {
            case DAY: {
                this.proceedDailyChart(chart, start, end, input);
                this.groupStatistics("yyyy-MM-dd", input, chart);
                break;
            }
            case WEEK: {
                this.proceedDailyChart(chart, start, end, input);
                this.groupStatistics("yyyy-MM-dd", input, chart);
                break;
            }
            case MONTH: {
                this.proceedMonthlyChart(chart, start, end, input);
                this.groupStatistics("yyyy-MM", input, chart);
            }
        }
        return chart;
    }

    protected Map<String, ChartStatisticsContent> maxByDate(List<ChartStatisticsContent> statisticsContents, Period period, String contentField) {
        Function<ChartStatisticsContent, String> chartObjectToDate = chartObject -> new DateTime(chartObject.getStartTime().getTime()).toString("yyyy-MM-dd");
        BinaryOperator chartObjectReducer = (o1, o2) -> Integer.valueOf((String)o1.getValues().get(contentField)) > Integer.valueOf((String)o2.getValues().get(contentField)) ? o1 : o2;
        Map groupByDate = statisticsContents.stream().filter(content -> MapUtils.isNotEmpty((Map)content.getValues()) && Optional.ofNullable(content.getValues().get(contentField)).isPresent()).sorted(Comparator.comparing(AbstractLaunchStatisticsContent::getStartTime)).collect(Collectors.groupingBy(chartObjectToDate, LinkedHashMap::new, Collectors.reducing(chartObjectReducer)));
        Map<String, ChartStatisticsContent> range = this.groupByDate(statisticsContents, period);
        LinkedHashMap<String, ChartStatisticsContent> result = new LinkedHashMap<String, ChartStatisticsContent>();
        range.forEach((key, value) -> result.put((String)key, groupByDate.getOrDefault(key, Optional.of(this.createChartObject((ChartStatisticsContent)statisticsContents.get(0)))).get()));
        return result;
    }

    private void groupStatistics(String groupingPattern, List<ChartStatisticsContent> statisticsContents, Map<String, ChartStatisticsContent> chart) {
        Map groupedStatistics = statisticsContents.stream().collect(Collectors.groupingBy(c -> new DateTime((Object)c.getStartTime()).toString(groupingPattern), LinkedHashMap::new, Collectors.toList()));
        groupedStatistics.forEach((key, contents) -> chart.keySet().stream().filter(k -> k.startsWith((String)key)).findFirst().ifPresent(k -> {
            ChartStatisticsContent content = (ChartStatisticsContent)chart.get(k);
            contents.add(content);
            Map<String, String> values = contents.stream().map(v -> v.getValues().entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable(entry.getValue()).orElse("0"), (prev, curr) -> {
                prev = String.valueOf(Double.valueOf(prev) + Double.valueOf(curr));
                return prev;
            }));
            content.setValues(values);
            chart.put((String)k, content);
        }));
    }

    private void proceedDailyChart(Map<String, ChartStatisticsContent> chart, DateTime intermediate, DateTime end, List<ChartStatisticsContent> statisticsContents) {
        while (intermediate.isBefore((ReadableInstant)end)) {
            chart.put(intermediate.toString("yyyy-MM-dd"), this.createChartObject(statisticsContents.get(0)));
            intermediate = intermediate.plusDays(1);
        }
        chart.put(end.toString("yyyy-MM-dd"), this.createChartObject(statisticsContents.get(0)));
    }

    private void proceedMonthlyChart(Map<String, ChartStatisticsContent> chart, DateTime intermediate, DateTime end, List<ChartStatisticsContent> statisticsContents) {
        while (intermediate.isBefore((ReadableInstant)end)) {
            if (intermediate.getYear() == end.getYear()) {
                if (intermediate.getMonthOfYear() != end.getMonthOfYear()) {
                    chart.put(intermediate.toString("yyyy-MM-dd"), this.createChartObject(statisticsContents.get(0)));
                }
            } else {
                chart.put(intermediate.toString("yyyy-MM-dd"), this.createChartObject(statisticsContents.get(0)));
            }
            intermediate = intermediate.plusMonths(1);
        }
        chart.put(end.toString("yyyy-MM-dd"), this.createChartObject(statisticsContents.get(0)));
    }

    private ChartStatisticsContent createChartObject(ChartStatisticsContent input) {
        ChartStatisticsContent chartObject = new ChartStatisticsContent();
        chartObject.setValues(input.getValues().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "0")));
        return chartObject;
    }

    public static enum Period {
        DAY(1),
        WEEK(7),
        MONTH(30);

        private int value;

        private Period(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static boolean isPresent(String name) {
            return Period.findByName(name).isPresent();
        }

        public static Optional<Period> findByName(String name) {
            return Arrays.stream(Period.values()).filter(time -> time.name().equalsIgnoreCase(name)).findAny();
        }
    }
}

