/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.filter;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;

public abstract class AbstractStatisticsFilterStrategy
implements BuildFilterStrategy {
    @Override
    public Map<Filter, Sort> buildFilter(ReportPortalUser.ProjectDetails projectDetails, Widget widget) {
        return this.buildFilterSortMap(widget, projectDetails.getProjectId());
    }

    protected Map<Filter, Sort> buildFilterSortMap(Widget widget, Long projectId) {
        LinkedHashMap filterSortMap = Maps.newLinkedHashMap();
        Set<UserFilter> userFilters = Optional.ofNullable(widget.getFilters()).orElse(Collections.emptySet());
        Filter defaultFilter = this.buildDefaultFilter(widget, projectId);
        Optional.ofNullable(defaultFilter).ifPresent(f -> filterSortMap.put(defaultFilter, Sort.unsorted()));
        userFilters.forEach(userFilter -> {
            Filter filter = new Filter(userFilter.getId(), userFilter.getTargetClass().getClassObject(), (List)Lists.newArrayList((Iterable)userFilter.getFilterCondition()));
            Optional<Set> filterSorts = Optional.ofNullable(userFilter.getFilterSorts());
            Sort sort = Sort.by((List)filterSorts.map(filterSort -> filterSort.stream().map(s -> Sort.Order.by((String)s.getField()).with(s.getDirection())).collect(Collectors.toList())).orElseGet(Collections::emptyList));
            filterSortMap.put(filter, sort);
        });
        return filterSortMap;
    }

    protected abstract Filter buildDefaultFilter(Widget var1, Long var2);
}

