/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.ProjectUser;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.PersonalProjectService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.builders.UserBuilder;
import com.epam.ta.reportportal.ws.converter.converters.UserConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.UserActivityResource;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.ws.model.user.CreateUserRS;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaveDefaultProjectService {
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final PersonalProjectService personalProjectService;
    private final MailServiceFactory emailServiceFactory;
    private final ShareableObjectsHandler aclHandler;
    private final ThreadPoolTaskExecutor emailExecutorService;

    @Autowired
    public SaveDefaultProjectService(ProjectRepository projectRepository, UserRepository userRepository, PersonalProjectService personalProjectService, MailServiceFactory emailServiceFactory, ShareableObjectsHandler aclHandler, ThreadPoolTaskExecutor emailExecutorService) {
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.personalProjectService = personalProjectService;
        this.emailServiceFactory = emailServiceFactory;
        this.aclHandler = aclHandler;
        this.emailExecutorService = emailExecutorService;
    }

    @Transactional
    public Pair<UserActivityResource, CreateUserRS> saveDefaultProject(CreateUserRQFull request, String basicUrl) {
        String projectName = EntityUtils.normalizeId((String)request.getDefaultProject());
        Project defaultProject = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        UserRole userRole = (UserRole)UserRole.findByName((String)request.getAccountRole()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect specified Account Role parameter."}));
        ProjectRole projectRole = (ProjectRole)ProjectRole.forName((String)request.getProjectRole()).orElseThrow(() -> new ReportPortalException(ErrorType.ROLE_NOT_FOUND, new Object[]{request.getProjectRole()}));
        User user = new UserBuilder().addCreateUserFullRQ(request).addUserRole(userRole).get();
        Set projectUsers = defaultProject.getUsers();
        ProjectUser assignedProjectUser = new ProjectUser().withProjectRole(projectRole).withUser(user).withProject(defaultProject);
        projectUsers.add(assignedProjectUser);
        defaultProject.setUsers(projectUsers);
        CreateUserRS response = new CreateUserRS();
        try {
            Project personalProject = (Project)this.projectRepository.save((Object)this.personalProjectService.generatePersonalProject(user));
            user.getProjects().add(assignedProjectUser);
            user.getProjects().add(personalProject.getUsers().stream().findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{personalProject.getName()})));
            this.userRepository.save((Object)user);
            Optional.ofNullable(basicUrl).ifPresent(url -> this.emailExecutorService.execute(() -> this.emailServiceFactory.getDefaultEmailService(true).sendCreateUserConfirmationEmail(request, (String)url)));
        }
        catch (PersistenceException pe) {
            if (pe.getCause() instanceof ConstraintViolationException) {
                BusinessRule.fail().withError(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{((ConstraintViolationException)pe.getCause()).getConstraintName()});
            }
            throw new ReportPortalException("Error while User creating: " + pe.getMessage(), (Throwable)pe);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while User creating: " + exp.getMessage(), (Throwable)exp);
        }
        this.authenticateUser(user);
        if (projectRole.sameOrHigherThan(ProjectRole.PROJECT_MANAGER)) {
            this.aclHandler.permitSharedObjects(defaultProject.getId(), user.getLogin(), BasePermission.ADMINISTRATION);
        } else {
            this.aclHandler.permitSharedObjects(defaultProject.getId(), user.getLogin(), BasePermission.READ);
        }
        response.setId(user.getId());
        response.setLogin(user.getLogin());
        return Pair.of((Object)UserConverter.TO_ACTIVITY_RESOURCE.apply(user, defaultProject.getId()), (Object)response);
    }

    private void authenticateUser(User user) {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)user.getLogin(), (Object)user.getPassword(), (Collection)Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_REGISTERED")})));
    }
}

