/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.hierarchy.FinishHierarchyHandler;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LaunchLinkGenerator;
import com.epam.ta.reportportal.core.launch.util.LaunchValidator;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.jooq.enums.JStatusEnum;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.FinishLaunchRS;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
public class FinishLaunchHandlerImpl
implements FinishLaunchHandler {
    private final LaunchRepository launchRepository;
    private final FinishHierarchyHandler<Launch> finishHierarchyHandler;
    private final MessageBus messageBus;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public FinishLaunchHandlerImpl(LaunchRepository launchRepository, @Qualifier(value="finishLaunchHierarchyHandler") FinishHierarchyHandler<Launch> finishHierarchyHandler, MessageBus messageBus, ApplicationEventPublisher eventPublisher) {
        this.launchRepository = launchRepository;
        this.finishHierarchyHandler = finishHierarchyHandler;
        this.messageBus = messageBus;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public FinishLaunchRS finishLaunch(String launchId, FinishExecutionRQ finishLaunchRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String baseUrl) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        LaunchValidator.validateRoles(launch, user, projectDetails);
        LaunchValidator.validate(launch, finishLaunchRQ);
        Optional status = StatusEnum.fromValue((String)finishLaunchRQ.getStatus());
        Long id = launch.getId();
        if (this.launchRepository.hasItemsInStatuses(launch.getId(), (List)Lists.newArrayList((Object[])new JStatusEnum[]{JStatusEnum.IN_PROGRESS}))) {
            this.finishHierarchyHandler.finishDescendants(launch, status.orElse(StatusEnum.INTERRUPTED), finishLaunchRQ.getEndTime(), user, projectDetails);
            launch.setStatus(this.launchRepository.hasItemsWithStatusNotEqual(id, StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED);
        } else {
            launch.setStatus(status.orElseGet(() -> this.launchRepository.hasItemsWithStatusNotEqual(id, StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED));
        }
        launch = new LaunchBuilder(launch).addDescription(this.buildDescription(launch.getDescription(), finishLaunchRQ.getDescription())).addAttributes(finishLaunchRQ.getAttributes()).addEndTime(finishLaunchRQ.getEndTime()).get();
        LaunchFinishedEvent event = new LaunchFinishedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user, baseUrl);
        this.messageBus.publishActivity(event);
        this.eventPublisher.publishEvent((Object)event);
        FinishLaunchRS response = new FinishLaunchRS();
        response.setId(launch.getUuid());
        response.setNumber(launch.getNumber());
        response.setLink(LaunchLinkGenerator.generateLaunchLink(baseUrl, projectDetails.getProjectName(), String.valueOf(launch.getId())));
        return response;
    }

    private String buildDescription(String existDescription, String fromRequestDescription) {
        if (null != existDescription) {
            return null != fromRequestDescription ? existDescription + " " + fromRequestDescription : existDescription;
        }
        return null;
    }
}

