/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.impl.IssueTypeHandler;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FromInterruptedStatusChangingStrategy
extends StatusChangingStrategy {
    private final LogIndexer logIndexer;
    private final LogRepository logRepository;

    @Autowired
    public FromInterruptedStatusChangingStrategy(TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, IssueTypeHandler issueTypeHandler, IssueEntityRepository issueEntityRepository, LaunchRepository launchRepository, MessageBus messageBus, LogIndexer logIndexer, LogRepository logRepository) {
        super(testItemRepository, itemAttributeRepository, issueTypeHandler, issueEntityRepository, launchRepository, messageBus);
        this.logIndexer = logIndexer;
        this.logRepository = logRepository;
    }

    @Override
    public void changeStatus(TestItem item, StatusEnum providedStatus, ReportPortalUser user, Long projectId) {
        BusinessRule.expect((Object)providedStatus, (Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.SKIPPED, StatusEnum.PASSED, StatusEnum.FAILED})).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Actual status: " + item.getItemResults().getStatus() + " can be switched only to: " + StatusEnum.SKIPPED + ", " + StatusEnum.PASSED + " or " + StatusEnum.FAILED});
        TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply(item, projectId);
        item.getItemResults().setStatus(providedStatus);
        Optional skippedIssueAttribute = this.itemAttributeRepository.findByLaunchIdAndKeyAndSystem(item.getLaunchId(), "skippedIssue", true);
        if (StatusEnum.FAILED.equals((Object)providedStatus) || StatusEnum.SKIPPED.equals((Object)providedStatus) && skippedIssueAttribute.isPresent() && ((ItemAttribute)skippedIssueAttribute.get()).getValue().equals("true")) {
            this.addToInvestigateIssue(item, projectId);
        }
        this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply(item, projectId), user.getUserId(), user.getUsername()));
        if (StatusEnum.PASSED.equals((Object)providedStatus)) {
            Optional.ofNullable(item.getItemResults().getIssue()).ifPresent(issue -> {
                issue.setTestItemResults(null);
                this.issueEntityRepository.delete(issue);
                item.getItemResults().setIssue(null);
                this.logIndexer.cleanIndex(projectId, this.logRepository.findIdsByTestItemId(item.getItemId()));
            });
            this.changeStatusRecursively(item, user, projectId);
            Launch launch = (Launch)this.launchRepository.findById((Object)item.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{item.getLaunchId()}));
            if (launch.getStatus() != StatusEnum.IN_PROGRESS) {
                launch.setStatus(this.launchRepository.hasItemsWithStatusNotEqual(launch.getId(), StatusEnum.PASSED) ? StatusEnum.FAILED : StatusEnum.PASSED);
            }
        }
    }
}

