/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.util;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.integration.util.AbstractBtsIntegrationService;
import com.epam.ta.reportportal.core.integration.util.property.BtsProperties;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.dao.IntegrationRepository;
import com.epam.ta.reportportal.entity.enums.AuthType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RallyIntegrationService
extends AbstractBtsIntegrationService {
    @Autowired
    public RallyIntegrationService(IntegrationRepository integrationRepository, PluginBox pluginBox) {
        super(integrationRepository, pluginBox);
    }

    @Override
    public Map<String, Object> retrieveIntegrationParams(Map<String, Object> integrationParams) {
        BusinessRule.expect(integrationParams, MapUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"No integration params provided"});
        HashMap resultParams = Maps.newHashMapWithExpectedSize((int)BtsProperties.values().length);
        BtsProperties.AUTH_TYPE.getParam(integrationParams).ifPresent(authName -> {
            AuthType authType = (AuthType)AuthType.findByName((String)authName).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_AUTHENTICATION_TYPE, new Object[]{authName}));
            if (!AuthType.OAUTH.equals((Object)authType)) {
                throw new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Unsupported auth type for Rally integration - " + authType.name()});
            }
            resultParams.put(BtsProperties.OAUTH_ACCESS_KEY.getName(), BtsProperties.OAUTH_ACCESS_KEY.getParam(integrationParams).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"AccessKey value cannot be NULL"})));
            resultParams.put(BtsProperties.AUTH_TYPE.getName(), authName);
        });
        BtsProperties.PROJECT.getParam(integrationParams).ifPresent(btsProject -> resultParams.put(BtsProperties.PROJECT.getName(), btsProject));
        BtsProperties.URL.getParam(integrationParams).ifPresent(btsProject -> resultParams.put(BtsProperties.URL.getName(), btsProject));
        Optional.ofNullable(integrationParams.get("defectFormFields")).ifPresent(defectFormFields -> resultParams.put("defectFormFields", defectFormFields));
        return resultParams;
    }
}

