/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.integration.plugin.DeletePluginHandler;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeletePluginHandlerImpl
implements DeletePluginHandler {
    private final IntegrationTypeRepository integrationTypeRepository;
    private final Pf4jPluginBox pluginBox;

    @Autowired
    public DeletePluginHandlerImpl(IntegrationTypeRepository integrationTypeRepository, Pf4jPluginBox pluginBox) {
        this.integrationTypeRepository = integrationTypeRepository;
        this.pluginBox = pluginBox;
    }

    @Override
    public OperationCompletionRS deleteById(Long id) {
        IntegrationType integrationType = (IntegrationType)this.integrationTypeRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin with id = '{}' not found", (Object[])new Object[]{id}).get()}));
        if (!this.pluginBox.deletePlugin(integrationType.getName())) {
            throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{"Unable to remove from plugin manager."});
        }
        this.integrationTypeRepository.deleteById((Object)integrationType.getId());
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Plugin = '{}' has been successfully removed", (Object[])new Object[]{integrationType.getName()}).get());
    }
}

