/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.integration.plugin.impl;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.integration.plugin.CreatePluginHandler;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CreatePluginHandlerImpl
implements CreatePluginHandler {
    private final Pf4jPluginBox pluginBox;

    @Autowired
    public CreatePluginHandlerImpl(Pf4jPluginBox pluginBox) {
        this.pluginBox = pluginBox;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EntryCreatedRS uploadPlugin(MultipartFile pluginFile) {
        String newPluginFileName = pluginFile.getOriginalFilename();
        BusinessRule.expect((Object)newPluginFileName, StringUtils::isNotBlank).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"File name should be not empty."});
        try (InputStream inputStream = pluginFile.getInputStream();){
            IntegrationType integrationType = this.pluginBox.uploadPlugin(newPluginFileName, inputStream);
            EntryCreatedRS entryCreatedRS = new EntryCreatedRS(integrationType.getId());
            return entryCreatedRS;
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{"Error during file stream retrieving"});
        }
    }
}

