/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import java.util.Arrays;

public enum XunitReportTag {
    TESTSUITES("testsuites"),
    TESTSUITE("testsuite"),
    TESTCASE("testcase"),
    ERROR("error"),
    WARNING("warning"),
    FAILURE("failure"),
    SYSTEM_ERR("system-err"),
    SYSTEM_OUT("system-out"),
    ATTR_NAME("name"),
    ATTR_TIME("time"),
    SKIPPED("skipped"),
    ATTR_TYPE("type"),
    ATTR_MESSAGE("message"),
    PROPERTIES("properties"),
    PROPERTY("property"),
    ATTR_VALUE("value"),
    TIMESTAMP("timestamp"),
    UNKNOWN("unknown");

    private String value;

    private XunitReportTag(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static XunitReportTag fromString(String type) {
        return Arrays.stream(XunitReportTag.values()).filter(it -> it.getValue().equalsIgnoreCase(type)).findAny().orElse(UNKNOWN);
    }
}

