/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.CriteriaHolder;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.FilterCreatedEvent;
import com.epam.ta.reportportal.core.events.activity.FilterUpdatedEvent;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.filter.ObjectType;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.builders.UserFilterBuilder;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.model.CollectionsRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.UserFilterActivityResource;
import com.epam.ta.reportportal.ws.model.filter.BulkUpdateFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UpdateUserFilterRQ;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateUserFilterHandlerImpl
implements UpdateUserFilterHandler {
    private final GetShareableEntityHandler<UserFilter> getShareableEntityHandler;
    private final UserFilterRepository userFilterRepository;
    private final WidgetRepository widgetRepository;
    private final ShareableObjectsHandler aclHandler;
    private final MessageBus messageBus;

    @Autowired
    public UpdateUserFilterHandlerImpl(GetShareableEntityHandler<UserFilter> getShareableEntityHandler, UserFilterRepository userFilterRepository, WidgetRepository widgetRepository, ShareableObjectsHandler aclHandler, MessageBus messageBus) {
        this.getShareableEntityHandler = getShareableEntityHandler;
        this.userFilterRepository = userFilterRepository;
        this.widgetRepository = widgetRepository;
        this.aclHandler = aclHandler;
        this.messageBus = messageBus;
    }

    @Override
    public EntryCreatedRS createFilter(UpdateUserFilterRQ createFilterRQ, String projectName, ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, projectName);
        this.validateFilterRq(createFilterRQ);
        BusinessRule.expect((Object)this.userFilterRepository.existsByNameAndOwnerAndProjectId(createFilterRQ.getName(), user.getUsername(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.USER_FILTER_ALREADY_EXISTS, new Object[]{createFilterRQ.getName(), user.getUsername(), projectName});
        UserFilter filter = new UserFilterBuilder().addFilterRq(createFilterRQ).addProject(projectDetails.getProjectId()).addOwner(user.getUsername()).get();
        this.userFilterRepository.save((Object)filter);
        this.aclHandler.initAcl(filter, user.getUsername(), projectDetails.getProjectId(), BooleanUtils.isTrue((Boolean)createFilterRQ.getShare()));
        this.messageBus.publishActivity(new FilterCreatedEvent(UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(filter), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(filter.getId());
    }

    @Override
    public OperationCompletionRS updateUserFilter(Long userFilterId, UpdateUserFilterRQ updateRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        this.validateFilterRq(updateRQ);
        UserFilter userFilter = this.getShareableEntityHandler.getAdministrated(userFilterId, projectDetails);
        BusinessRule.expect((Object)userFilter.getProject().getId(), Predicate.isEqual(projectDetails.getProjectId())).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{userFilterId, projectDetails.getProjectId(), user.getUserId()});
        if (!userFilter.getName().equals(updateRQ.getName())) {
            BusinessRule.expect((Object)this.userFilterRepository.existsByNameAndOwnerAndProjectId(updateRQ.getName(), userFilter.getOwner(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.USER_FILTER_ALREADY_EXISTS, new Object[]{updateRQ.getName(), userFilter.getOwner(), projectDetails.getProjectName()});
        }
        UserFilterActivityResource before = UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(userFilter);
        UserFilter updated = new UserFilterBuilder(userFilter).addFilterRq(updateRQ).get();
        if (before.isShared() != updated.isShared()) {
            this.aclHandler.updateAcl(updated, projectDetails.getProjectId(), updated.isShared());
            if (!updated.isShared()) {
                this.widgetRepository.deleteRelationByFilterIdAndNotOwner(updated.getId(), updated.getOwner());
            }
        }
        this.messageBus.publishActivity(new FilterUpdatedEvent(before, UserFilterConverter.TO_ACTIVITY_RESOURCE.apply(updated), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("User filter with ID = '" + updated.getId() + "' successfully updated.");
    }

    @Override
    public List<OperationCompletionRS> updateUserFilter(CollectionsRQ<BulkUpdateFilterRQ> updateRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void updateSharing(Collection<UserFilter> filters, Long projectId, boolean isShared) {
        ArrayList filtersToSave = Lists.newArrayListWithCapacity((int)filters.size());
        filters.forEach(filter -> {
            if (filter.isShared() != isShared) {
                filter.setShared(isShared);
                this.aclHandler.updateAcl(filter, projectId, filter.isShared());
                filtersToSave.add(filter);
            }
        });
        this.userFilterRepository.saveAll((Iterable)filtersToSave);
    }

    private void validateFilterRq(UpdateUserFilterRQ updateFilerRq) {
        FilterTarget filterTarget = FilterTarget.findByClass((Class)ObjectType.getObjectTypeByName((String)updateFilerRq.getObjectType()).getClassObject());
        BusinessRule.expect((Object)updateFilerRq.getConditions(), (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter conditions should not be empty"});
        BusinessRule.expect((Object)updateFilerRq.getOrders(), (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Sort conditions should not be empty"});
        updateFilerRq.getConditions().forEach(it -> {
            CriteriaHolder criteriaHolder = (CriteriaHolder)filterTarget.getCriteriaByFilter(it.getFilteringField()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Filter parameter '{}' is not defined", (Object[])new Object[]{it.getFilteringField()}).get()}));
            Condition condition = (Condition)Condition.findByMarker((String)it.getCondition()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{it.getCondition()}));
            boolean isNegative = Condition.isNegative((String)it.getCondition());
            condition.validate(criteriaHolder, it.getValue(), isNegative, ErrorType.INCORRECT_FILTER_PARAMETERS);
            condition.castValue(criteriaHolder, it.getValue(), ErrorType.INCORRECT_FILTER_PARAMETERS);
        });
        updateFilerRq.getOrders().forEach(order -> BusinessRule.expect((Object)filterTarget.getCriteriaByFilter(order.getSortingColumnName()), Optional::isPresent).verify(ErrorType.INCORRECT_SORTING_PARAMETERS, new Object[]{"Unable to find sort parameter '" + order.getSortingColumnName() + "'"}));
    }
}

