/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler.subscriber.impl;

import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.events.handler.subscriber.LaunchFinishedEventSubscriber;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.SendCase;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.project.email.LaunchAttributeRule;
import com.epam.ta.reportportal.entity.project.email.SenderCase;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchNotificationSubscriber
implements LaunchFinishedEventSubscriber {
    public static final Logger LOGGER = LoggerFactory.getLogger(LaunchNotificationSubscriber.class);
    private final GetIntegrationHandler getIntegrationHandler;
    private final MailServiceFactory mailServiceFactory;
    private final LaunchRepository launchRepository;
    private final UserRepository userRepository;

    @Autowired
    public LaunchNotificationSubscriber(GetIntegrationHandler getIntegrationHandler, MailServiceFactory mailServiceFactory, LaunchRepository launchRepository, UserRepository userRepository) {
        this.getIntegrationHandler = getIntegrationHandler;
        this.mailServiceFactory = mailServiceFactory;
        this.launchRepository = launchRepository;
        this.userRepository = userRepository;
    }

    @Override
    public void handleEvent(LaunchFinishedEvent launchFinishedEvent, Project project, Launch launch) {
        boolean isNotificationsEnabled = BooleanUtils.toBoolean((String)((String)ProjectUtils.getConfigParameters((Set)project.getProjectAttributes()).get(ProjectAttributeEnum.NOTIFICATIONS_ENABLED.getAttribute())));
        if (isNotificationsEnabled) {
            Integration emailIntegration = this.getIntegrationHandler.getEnabledByProjectIdOrGlobalAndIntegrationGroup(project.getId(), IntegrationGroupEnum.NOTIFICATION).orElseThrow(() -> new ReportPortalException(ErrorType.INTEGRATION_NOT_FOUND, new Object[]{"EMAIL"}));
            Optional<EmailService> emailService = this.mailServiceFactory.getDefaultEmailService(emailIntegration);
            emailService.ifPresent(it -> {
                this.launchRepository.refresh((Object)launch);
                this.sendEmail(launch, project, (EmailService)((Object)it), launchFinishedEvent.getBaseUrl());
            });
        }
    }

    private void sendEmail(Launch launch, Project project, EmailService emailService, String baseUrl) {
        project.getSenderCases().forEach(ec -> {
            SendCase sendCase = ec.getSendCase();
            boolean successRate = LaunchNotificationSubscriber.isSuccessRateEnough(launch, sendCase);
            boolean matchedNames = LaunchNotificationSubscriber.isLaunchNameMatched(launch, ec);
            boolean matchedTags = LaunchNotificationSubscriber.isAttributesMatched(launch, ec.getLaunchAttributeRules());
            Set recipients = ec.getRecipients();
            if (successRate && matchedNames && matchedTags) {
                String[] recipientsArray = this.findRecipients((String)this.userRepository.findLoginById(launch.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{launch.getUserId()})), recipients);
                try {
                    emailService.sendLaunchFinishNotification(recipientsArray, String.format("%s/ui/#%s", baseUrl, project.getName()), project, launch);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to send email. Error: \n{}", (Throwable)e);
                }
            }
        });
    }

    private String[] findRecipients(String owner, Set<String> recipients) {
        return (String[])recipients.stream().map(recipient -> {
            if (recipient.contains("@")) {
                return recipient;
            }
            String toFind = recipient.equals(ProjectUtils.getOwner()) ? owner : recipient;
            Optional user = this.userRepository.findByLogin(toFind);
            return user.map(User::getEmail).orElse(null);
        }).filter(Objects::nonNull).distinct().toArray(String[]::new);
    }

    private static double getSuccessRate(Launch launch) {
        double ti = StatisticsHelper.extractStatisticsCount("statistics$defects$to_investigate$total", launch.getStatistics()).doubleValue();
        double pb = StatisticsHelper.extractStatisticsCount("statistics$defects$product_bug$total", launch.getStatistics()).doubleValue();
        double si = StatisticsHelper.extractStatisticsCount("statistics$defects$system_issue$total", launch.getStatistics()).doubleValue();
        double ab = StatisticsHelper.extractStatisticsCount("statistics$defects$automation_bug$total", launch.getStatistics()).doubleValue();
        double total = StatisticsHelper.extractStatisticsCount("statistics$executions$total", launch.getStatistics()).doubleValue();
        return total == 0.0 ? total : (ti + pb + si + ab) / total;
    }

    private static boolean isSuccessRateEnough(Launch launch, SendCase option) {
        switch (option) {
            case ALWAYS: {
                return true;
            }
            case FAILED: {
                return launch.getStatus().equals((Object)StatusEnum.FAILED);
            }
            case TO_INVESTIGATE: {
                return StatisticsHelper.extractStatisticsCount("statistics$defects$to_investigate$total", launch.getStatistics()) > 0;
            }
            case MORE_10: {
                return LaunchNotificationSubscriber.getSuccessRate(launch) > 0.1;
            }
            case MORE_20: {
                return LaunchNotificationSubscriber.getSuccessRate(launch) > 0.2;
            }
            case MORE_50: {
                return LaunchNotificationSubscriber.getSuccessRate(launch) > 0.5;
            }
        }
        return false;
    }

    private static boolean isLaunchNameMatched(Launch launch, SenderCase oneCase) {
        Set configuredNames = oneCase.getLaunchNames();
        return null == configuredNames || configuredNames.isEmpty() || configuredNames.contains(launch.getName());
    }

    @VisibleForTesting
    private static boolean isAttributesMatched(Launch launch, Set<LaunchAttributeRule> launchAttributeRules) {
        if (CollectionUtils.isEmpty(launchAttributeRules)) {
            return true;
        }
        return launch.getAttributes().stream().filter(attribute -> attribute.isSystem() == false).map(attribute -> {
            ItemAttributeResource attributeResource = new ItemAttributeResource();
            attributeResource.setKey(attribute.getKey());
            attributeResource.setValue(attribute.getValue());
            return attributeResource;
        }).collect(Collectors.toSet()).containsAll(launchAttributeRules.stream().map(NotificationConfigConverter.TO_ATTRIBUTE_RULE_RESOURCE).collect(Collectors.toSet()));
    }

    public int getOrder() {
        return 2;
    }
}

