/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.job.CleanExpiredCreationBidsJob;
import com.epam.ta.reportportal.job.CleanLaunchesJob;
import com.epam.ta.reportportal.job.CleanLogsJob;
import com.epam.ta.reportportal.job.CleanScreenshotsJob;
import com.epam.ta.reportportal.job.InterruptBrokenLaunchesJob;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import javax.sql.DataSource;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
@EnableConfigurationProperties(value={QuartzProperties.class, CleanLogsJobProperties.class, CleanLaunchesJobProperties.class})
public class SchedulerConfiguration {
    @Autowired
    List<Trigger> listOfTrigger;
    @Autowired
    private QuartzProperties quartzProperties;
    @Autowired
    private AutowireCapableBeanFactory context;
    @Autowired
    private DataSource dataSource;

    @Bean
    @Primary
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean scheduler = new SchedulerFactoryBean();
        scheduler.setApplicationContextSchedulerContextKey("applicationContext");
        scheduler.setQuartzProperties(this.quartzProperties.getQuartz());
        scheduler.setDataSource(this.dataSource);
        scheduler.setAutoStartup(true);
        scheduler.setWaitForJobsToCompleteOnShutdown(true);
        scheduler.setJobFactory((JobFactory)this.beanJobFactory());
        if (null != this.listOfTrigger && !this.listOfTrigger.isEmpty()) {
            scheduler.setTriggers(this.listOfTrigger.toArray(new Trigger[this.listOfTrigger.size()]));
        }
        return scheduler;
    }

    @Bean
    public SpringBeanJobFactory beanJobFactory() {
        return new SpringBeanJobFactory(){

            protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
                Object jobInstance = super.createJobInstance(bundle);
                SchedulerConfiguration.this.context.autowireBean(jobInstance);
                return jobInstance;
            }
        };
    }

    @Bean
    public SimpleTriggerFactoryBean createCleanLogsTrigger(@Named(value="cleanLogsJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.logs.cron}") String cleanLogsCron) {
        return SchedulerConfiguration.createTrigger(jobDetail, Duration.parse(cleanLogsCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean interruptLaunchesTrigger(@Named(value="interruptLaunchesJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.interrupt.broken.launches.cron}") String interruptLaunchesCron) {
        return SchedulerConfiguration.createTrigger(jobDetail, Duration.parse(interruptLaunchesCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean cleanScreenshotsTrigger(@Named(value="cleanScreenshotsJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.screenshots.cron}") String cleanScreenshotsCron) {
        return SchedulerConfiguration.createTrigger(jobDetail, Duration.parse(cleanScreenshotsCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean createCleanLaunchesTrigger(@Named(value="cleanLaunchesJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.launches.cron}") String cleanLogsCron) {
        return SchedulerConfiguration.createTrigger(jobDetail, Duration.parse(cleanLogsCron).toMillis());
    }

    @Bean
    public SimpleTriggerFactoryBean cleanExpiredCreationBidsTrigger(@Named(value="cleanExpiredCreationBidsJobBean") JobDetail jobDetail, @Value(value="${com.ta.reportportal.job.clean.bids.cron}") String cleanBidsCron) {
        return SchedulerConfiguration.createTrigger(jobDetail, Duration.parse(cleanBidsCron).toMillis());
    }

    @Bean(value={"cleanLogsJobBean"})
    public JobDetailFactoryBean cleanLogsJob() {
        return SchedulerConfiguration.createJobDetail(CleanLogsJob.class);
    }

    @Bean(value={"interruptLaunchesJobBean"})
    public JobDetailFactoryBean interruptLaunchesJob() {
        return SchedulerConfiguration.createJobDetail(InterruptBrokenLaunchesJob.class);
    }

    @Bean(value={"cleanScreenshotsJobBean"})
    public JobDetailFactoryBean cleanScreenshotsJob() {
        return SchedulerConfiguration.createJobDetail(CleanScreenshotsJob.class);
    }

    @Bean(value={"cleanLaunchesJobBean"})
    public JobDetailFactoryBean cleanLaunchesJob() {
        return SchedulerConfiguration.createJobDetail(CleanLaunchesJob.class);
    }

    @Bean(value={"cleanExpiredCreationBidsJobBean"})
    public JobDetailFactoryBean cleanExpiredCreationBidsJob() {
        return SchedulerConfiguration.createJobDetail(CleanExpiredCreationBidsJob.class);
    }

    public static SimpleTriggerFactoryBean createTrigger(JobDetail jobDetail, long pollFrequencyMs) {
        SimpleTriggerFactoryBean factoryBean = new SimpleTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setStartDelay(0L);
        factoryBean.setRepeatInterval(pollFrequencyMs);
        factoryBean.setRepeatCount(-1);
        factoryBean.setMisfireInstruction(4);
        return factoryBean;
    }

    public static CronTriggerFactoryBean createCronTrigger(JobDetail jobDetail, String cronExpression) {
        CronTriggerFactoryBean factoryBean = new CronTriggerFactoryBean();
        factoryBean.setJobDetail(jobDetail);
        factoryBean.setCronExpression(cronExpression);
        factoryBean.setMisfireInstruction(1);
        return factoryBean;
    }

    public static JobDetailFactoryBean createJobDetail(Class<? extends Job> jobClass) {
        JobDetailFactoryBean factoryBean = new JobDetailFactoryBean();
        factoryBean.setJobClass(jobClass);
        factoryBean.setDurability(true);
        return factoryBean;
    }

    @ConfigurationProperties(value="com.ta.reportportal.job.clean.launches")
    public static class CleanLaunchesJobProperties {
        private Integer timeout;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }
    }

    @ConfigurationProperties(value="com.ta.reportportal.job.clean.logs")
    public static class CleanLogsJobProperties {
        private Integer timeout;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }
    }

    @ConfigurationProperties(value="spring.application")
    public static class QuartzProperties {
        private final Properties quartz = new Properties();

        public Properties getQuartz() {
            return this.quartz;
        }
    }
}

