/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.integration.plugin.PluginLoader;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.plugin.Pf4jPluginManager;
import com.epam.ta.reportportal.plugin.ReportPortalExtensionFactory;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.pf4j.DefaultExtensionFinder;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.ExtensionFinder;
import org.pf4j.LegacyExtensionFinder;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginStateListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PluginConfiguration {
    @Autowired
    private AutowireCapableBeanFactory context;
    @Autowired
    private PluginLoader pluginLoader;
    @Autowired
    private IntegrationTypeRepository integrationTypeRepository;
    @Value(value="${rp.plugins.path}")
    private String pluginsPath;
    @Value(value="${rp.plugins.temp.path}")
    private String pluginsTempPath;

    @Bean
    public Pf4jPluginBox pf4jPluginBox() throws IOException {
        Pf4jPluginManager manager = new Pf4jPluginManager(this.pluginsPath, this.pluginsTempPath, this.pluginLoader, this.integrationTypeRepository, this.pluginManager(), this.context);
        manager.startAsync();
        return manager;
    }

    @Bean
    public PluginManager pluginManager() {
        return new DefaultPluginManager(Paths.get(this.pluginsPath, new String[0])){

            protected PluginDescriptorFinder createPluginDescriptorFinder() {
                return PluginConfiguration.this.pluginDescriptorFinder();
            }

            protected ExtensionFactory createExtensionFactory() {
                return new ReportPortalExtensionFactory((PluginManager)this, PluginConfiguration.this.context);
            }

            protected ExtensionFinder createExtensionFinder() {
                RpExtensionFinder extensionFinder = new RpExtensionFinder((PluginManager)this);
                this.addPluginStateListener((PluginStateListener)extensionFinder);
                return extensionFinder;
            }

            class RpExtensionFinder
            extends DefaultExtensionFinder {
                RpExtensionFinder(PluginManager pluginManager) {
                    super(pluginManager);
                    this.finders.clear();
                    this.finders.add(new LegacyExtensionFinder(pluginManager){

                        public Set<String> findClassNames(String pluginId) {
                            return Optional.ofNullable(super.findClassNames(pluginId)).orElseGet(Collections::emptySet);
                        }
                    });
                }
            }
        };
    }

    @Bean
    public PluginDescriptorFinder pluginDescriptorFinder() {
        return new ManifestPluginDescriptorFinder();
    }
}

