/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.item.impl.TestItemUniqueIdGenerator;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.BasicLaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.BasicStatisticsCalculationStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.DeepLaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.LaunchMergeFactory;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.StatisticsCalculationFactory;
import com.epam.ta.reportportal.core.item.merge.LaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.merge.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MergeStrategyConfig {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final TestItemUniqueIdGenerator testItemUniqueIdGenerator;

    @Autowired
    public MergeStrategyConfig(TestItemRepository testItemRepository, LaunchRepository launchRepository, TestItemUniqueIdGenerator testItemUniqueIdGenerator) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.testItemUniqueIdGenerator = testItemUniqueIdGenerator;
    }

    @Bean
    public Map<MergeStrategyType, StatisticsCalculationStrategy> statisticsCalculationStrategyMaping() {
        return Collections.singletonMap(MergeStrategyType.BASIC, new BasicStatisticsCalculationStrategy());
    }

    @Bean
    public StatisticsCalculationFactory statisticsCalculationFactory() {
        return new StatisticsCalculationFactory(this.statisticsCalculationStrategyMaping());
    }

    @Bean
    public Map<MergeStrategyType, LaunchMergeStrategy> launchMergeStrategyMapping() {
        return ImmutableMap.builder().put((Object)MergeStrategyType.BASIC, (Object)new BasicLaunchMergeStrategy(this.testItemRepository, this.testItemUniqueIdGenerator, this.launchRepository, this.statisticsCalculationFactory())).put((Object)MergeStrategyType.DEEP, (Object)new DeepLaunchMergeStrategy(this.testItemRepository, this.testItemUniqueIdGenerator, this.launchRepository)).build();
    }

    @Bean
    public LaunchMergeFactory launchMergeFactory() {
        return new LaunchMergeFactory(this.launchMergeStrategyMapping());
    }
}

