/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.strategy;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.analyzer.auto.AnalyzerServiceAsync;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeCollectorFactory;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsMode;
import com.epam.ta.reportportal.core.analyzer.strategy.AbstractLaunchAnalysisStrategy;
import com.epam.ta.reportportal.core.events.AnalysisEvent;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.AnalyzeMode;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.AnalyzeLaunchRQ;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class LaunchAutoAnalysisStrategy
extends AbstractLaunchAnalysisStrategy {
    private final AnalyzerServiceAsync analyzerServiceAsync;
    private final AnalyzeCollectorFactory analyzeCollectorFactory;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public LaunchAutoAnalysisStrategy(ProjectRepository projectRepository, LaunchRepository launchRepository, AnalyzerServiceAsync analyzerServiceAsync, AnalyzeCollectorFactory analyzeCollectorFactory, ApplicationEventPublisher eventPublisher) {
        super(projectRepository, launchRepository);
        this.analyzerServiceAsync = analyzerServiceAsync;
        this.analyzeCollectorFactory = analyzeCollectorFactory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void analyze(AnalyzeLaunchRQ analyzeRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        BusinessRule.expect((Object)this.analyzerServiceAsync.hasAnalyzers(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer services are deployed."});
        AnalyzeMode analyzeMode = (AnalyzeMode)AnalyzeMode.fromString((String)analyzeRQ.getAnalyzerHistoryMode()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{analyzeRQ.getAnalyzerHistoryMode()}));
        Launch launch = (Launch)this.launchRepository.findById((Object)analyzeRQ.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{analyzeRQ.getLaunchId()}));
        this.validateLaunch(launch, projectDetails);
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(project);
        analyzerConfig.setAnalyzerMode(analyzeMode.getValue());
        List<Long> itemIds = this.collectItemsByModes(launch.getId(), analyzeRQ.getAnalyzeItemsModes(), project, user);
        this.eventPublisher.publishEvent((Object)new AnalysisEvent(launch, itemIds, analyzerConfig));
    }

    private List<Long> collectItemsByModes(Long launchId, List<String> analyzeItemsMode, Project project, ReportPortalUser user) {
        return analyzeItemsMode.stream().map(AnalyzeItemsMode::fromString).flatMap(it -> this.analyzeCollectorFactory.getCollector((AnalyzeItemsMode)((Object)it)).collectItems(project.getId(), launchId, user).stream()).distinct().collect(Collectors.toList());
    }
}

