/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.ta.reportportal.core.analyzer.auto.client.IndexerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.epam.ta.reportportal.ws.model.analyzer.CleanIndexRq;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.analyzer.IndexRs;
import java.util.List;
import java.util.Objects;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class IndexerServiceClientImpl
implements IndexerServiceClient {
    private static final String INDEX_ROUTE = "index";
    private static final String DELETE_ROUTE = "delete";
    private static final String CLEAN_ROUTE = "clean";
    private final RabbitMqManagementClient rabbitMqManagementClient;
    private final RabbitTemplate rabbitTemplate;

    public IndexerServiceClientImpl(RabbitMqManagementClient rabbitMqManagementClient, @Qualifier(value="analyzerRabbitTemplate") RabbitTemplate rabbitTemplate) {
        this.rabbitMqManagementClient = rabbitMqManagementClient;
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public Long index(List<IndexLaunch> rq) {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).map(exchange -> (IndexRs)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), INDEX_ROUTE, (Object)rq, (ParameterizedTypeReference)new ParameterizedTypeReference<IndexRs>(){})).mapToLong(it -> {
            if (Objects.nonNull(it) && it.getItems() != null) {
                return it.getItems().size();
            }
            return 0L;
        }).sum();
    }

    @Override
    public void cleanIndex(Long index, List<Long> ids) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().forEach(exchange -> this.rabbitTemplate.convertAndSend(exchange.getName(), CLEAN_ROUTE, (Object)new CleanIndexRq(index, ids)));
    }

    @Override
    public void deleteIndex(Long index) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().forEach(exchange -> this.rabbitTemplate.convertAndSend(exchange.getName(), DELETE_ROUTE, (Object)index));
    }
}

