/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.settings.OAuth2LoginDetails;
import com.epam.ta.reportportal.ws.model.settings.OAuthDetailsResource;
import com.google.common.base.Preconditions;
import java.util.function.Function;

public final class OAuthDetailsConverters {
    public static final Function<OAuthDetailsResource, OAuth2LoginDetails> FROM_RESOURCE = resource -> {
        Preconditions.checkNotNull((Object)resource);
        OAuth2LoginDetails db = new OAuth2LoginDetails();
        db.setClientAuthenticationScheme(resource.getClientAuthenticationScheme());
        db.setUserAuthorizationUri(resource.getUserAuthorizationUri());
        db.setAccessTokenUri(resource.getAccessTokenUri());
        db.setClientId(resource.getClientId());
        db.setClientSecret(resource.getClientSecret());
        db.setGrantType(resource.getGrantType());
        db.setScope(resource.getScope());
        db.setRestrictions(resource.getRestrictions());
        db.setAuthenticationScheme(resource.getAuthenticationScheme());
        db.setTokenName(resource.getTokenName());
        return db;
    };
    public static final Function<OAuth2LoginDetails, OAuthDetailsResource> TO_RESOURCE = db -> {
        Preconditions.checkNotNull((Object)db);
        OAuthDetailsResource resource = new OAuthDetailsResource();
        resource.setClientAuthenticationScheme(db.getClientAuthenticationScheme());
        resource.setUserAuthorizationUri(db.getUserAuthorizationUri());
        resource.setAccessTokenUri(db.getAccessTokenUri());
        resource.setClientId(db.getClientId());
        resource.setClientSecret(db.getClientSecret());
        resource.setGrantType(db.getGrantType());
        resource.setScope(db.getScope());
        resource.setRestrictions(db.getRestrictions());
        resource.setAuthenticationScheme(db.getAuthenticationScheme());
        resource.setTokenName(db.getTokenName());
        return resource;
    };

    private OAuthDetailsConverters() {
    }
}

