/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;

public final class LogConverter {
    public static final Function<Log, LogResource> TO_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        LogResource resource = new LogResource();
        resource.setIdLog(model.getId());
        resource.setMessage(Optional.ofNullable(model.getLogMsg()).orElse("NULL"));
        resource.setLogTime(model.getLogTime());
        Optional.ofNullable(model.getBinaryContent()).ifPresent(content -> {
            LogResource.BinaryContent binaryContent = new LogResource.BinaryContent();
            binaryContent.setBinaryDataId(content.getBinaryDataId());
            binaryContent.setContentType(content.getContentType());
            binaryContent.setThumbnailId(content.getThumbnailId());
            resource.setBinaryContent(binaryContent);
        });
        resource.setTestItem(model.getTestItemRef());
        Optional.ofNullable(model.getLevel()).ifPresent(level -> resource.setLevel(level.toString()));
        return resource;
    };

    private LogConverter() {
    }
}

