/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.ws.converter.builders.ShareableEntityBuilder;
import com.epam.ta.reportportal.ws.model.widget.ContentParameters;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class WidgetBuilder
extends ShareableEntityBuilder<Widget> {
    public WidgetBuilder addWidgetRQ(WidgetRQ createRQ) {
        if (createRQ != null) {
            if (createRQ.getName() != null) {
                ((Widget)this.getObject()).setName(createRQ.getName().trim());
            }
            this.addContentParameters(createRQ.getContentParameters());
        }
        return this;
    }

    public WidgetBuilder addContentParameters(ContentParameters parameters) {
        if (parameters != null) {
            ContentOptions contentOptions = new ContentOptions();
            contentOptions.setType(parameters.getType());
            contentOptions.setGadgetType(parameters.getGadget());
            contentOptions.setContentFields(null != parameters.getContentFields() ? Lists.newArrayList((Iterable)EntityUtils.trimStrings((Iterable)parameters.getContentFields())) : null);
            contentOptions.setMetadataFields(null != parameters.getMetadataFields() ? Lists.newArrayList((Iterable)EntityUtils.trimStrings((Iterable)parameters.getMetadataFields())) : null);
            contentOptions.setItemsCount(parameters.getItemsCount());
            contentOptions.setWidgetOptions(null != parameters.getWidgetOptions() ? Maps.newHashMap((Map)parameters.getWidgetOptions()) : null);
            ((Widget)this.getObject()).setContentOptions(contentOptions);
        }
        return this;
    }

    public WidgetBuilder addProject(String projectName) {
        ((Widget)this.getObject()).setProjectName(projectName);
        return this;
    }

    public WidgetBuilder addFilter(String applyingFilterId) {
        ((Widget)this.getObject()).setApplyingFilterId(applyingFilterId);
        return this;
    }

    public WidgetBuilder addDescription(String description) {
        if (!Strings.isNullOrEmpty((String)description)) {
            ((Widget)this.getObject()).setDescription(description);
        }
        return this;
    }

    protected Widget initObject() {
        return new Widget();
    }

    public WidgetBuilder addSharing(String owner, String project, String description, boolean isShare) {
        super.addAcl(owner, project, description, isShare);
        return this;
    }
}

