/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;

public class LaunchBuilder
implements Supplier<Launch> {
    private Launch launch = new Launch();

    public LaunchBuilder addStartRQ(StartLaunchRQ request) {
        if (request != null) {
            this.launch.setStartTime(request.getStartTime());
            this.launch.setName(request.getName().trim());
            this.addDescription(request.getDescription());
            this.addTags(request.getTags());
            if (request.getMode() != null) {
                this.launch.setMode(request.getMode());
            }
        }
        return this;
    }

    public LaunchBuilder addDescription(String description) {
        if (!Strings.isNullOrEmpty((String)description)) {
            this.launch.setDescription(description.trim());
        }
        return this;
    }

    public LaunchBuilder addTags(Set<String> tags) {
        if (!CollectionUtils.isEmpty(tags)) {
            HashSet trimmedTags = Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update(tags)));
            this.launch.setTags((Set)trimmedTags);
        }
        return this;
    }

    public LaunchBuilder addStatus(Status status) {
        this.launch.setStatus(status);
        return this;
    }

    public LaunchBuilder addUser(String userName) {
        this.launch.setUserRef(userName);
        return this;
    }

    public LaunchBuilder addProject(String projectName) {
        this.launch.setProjectRef(projectName);
        return this;
    }

    public LaunchBuilder addEndTime(Date endTime) {
        this.launch.setEndTime(endTime);
        return this;
    }

    @Override
    public Launch get() {
        return this.launch;
    }
}

