/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class TestItemResourceAssembler
extends PagedResourcesAssembler<TestItem, TestItemResource> {
    @Autowired
    private TestItemRepository testItemRepository;

    public com.epam.ta.reportportal.ws.model.Page<TestItemResource> toPagedResources(Page<TestItem> content) {
        com.epam.ta.reportportal.ws.model.Page resources = super.toPagedResources(content);
        Map allPathsNames = this.getPagePathNames(content);
        this.setPathElementsNames(resources, allPathsNames);
        return resources;
    }

    public TestItemResource toResource(TestItem entity) {
        TestItemResource resource = (TestItemResource)TestItemConverter.TO_RESOURCE.apply(entity);
        resource.setPathNames(this.getItemName(entity.getPath()));
        return resource;
    }

    public TestItemResource toResource(TestItem item, String launchStatus) {
        TestItemResource resource = (TestItemResource)TestItemConverter.TO_RESOURCE.apply(item);
        resource.setLaunchStatus(launchStatus);
        resource.setPathNames(this.getItemName(item.getPath()));
        return resource;
    }

    private Map<String, String> getPagePathNames(Iterable<TestItem> content) {
        return this.getItemName(StreamSupport.stream(content.spliterator(), false).flatMap(it -> it.getPath().stream()).distinct().collect(Collectors.toList()));
    }

    private void setPathElementsNames(com.epam.ta.reportportal.ws.model.Page<TestItemResource> resources, Map<String, String> allPathsNames) {
        for (TestItemResource testItemResource : resources) {
            testItemResource.getPathNames().keySet().forEach(pathId -> testItemResource.getPathNames().put(pathId, allPathsNames.get(pathId)));
        }
    }

    private Map<String, String> getItemName(List<String> ids) {
        Map result = this.testItemRepository.findPathNames(ids);
        LinkedHashMap<String, String> orderedResult = new LinkedHashMap<String, String>();
        for (String id : ids) {
            orderedResult.put(id, (String)result.get(id));
        }
        return orderedResult;
    }
}

