/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.migration;

import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

@ChangeLog(order="3.1.1")
public class ChangeSets_3_1_1 {
    private static final String LEAD_ROLE = "LEAD";
    private static final String ID_FIELD = "_id";

    @ChangeSet(order="3.1.1-1", id="v3.1.1-Remove LEAD project role", author="avarabyeu")
    public void removeLeadRole(MongoTemplate mongoTemplate) {
        Query q = new Query();
        q.fields().include(ID_FIELD).include("users");
        mongoTemplate.stream(q, DBObject.class, "project").forEachRemaining(dbo -> {
            if (null != dbo.get("users")) {
                DBObject users = (DBObject)dbo.get("users");
                users.keySet().forEach(username -> {
                    DBObject user = (DBObject)users.get(username);
                    Update u = new Update();
                    boolean requireUpdate = false;
                    if (LEAD_ROLE.equals(user.get("proposedRole"))) {
                        u.set(String.format("users.%s.proposedRole", username), (Object)ProjectRole.PROJECT_MANAGER.toString());
                        requireUpdate = true;
                    }
                    if (LEAD_ROLE.equals(user.get("projectRole"))) {
                        u.set(String.format("users.%s.projectRole", username), (Object)ProjectRole.PROJECT_MANAGER.toString());
                        requireUpdate = true;
                    }
                    if (requireUpdate) {
                        mongoTemplate.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is(dbo.get(ID_FIELD))), u, "project");
                    }
                });
            }
        });
    }
}

