/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.reportportal.commons.ContentTypeResolver;
import com.epam.reportportal.commons.Thumbnailator;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.entity.BinaryContent;
import com.epam.ta.reportportal.database.entity.Log;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class SaveBinaryDataJob
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveBinaryDataJob.class);
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private DataStorage dataStorageService;
    @Autowired
    private Thumbnailator thumbnailator;
    @Autowired
    private ContentTypeResolver contentTypeResolver;
    private MultipartFile file;
    private String project;
    private Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BinaryData binaryData = !Strings.isNullOrEmpty((String)this.file.getContentType()) && !"application/octet-stream".equals(this.file.getContentType()) ? new BinaryData(this.file.getContentType(), Long.valueOf(this.file.getSize()), this.file.getInputStream()) : new BinaryData(this.contentTypeResolver.detectContentType(this.file.getInputStream()), Long.valueOf(this.file.getSize()), this.file.getInputStream());
            String thumbnailId = null;
            Map<String, String> metadata = Collections.singletonMap("project", this.project);
            if (this.isImage(binaryData.getContentType())) {
                try {
                    InputStream thumbnailStream = this.thumbnailator.createThumbnail(this.file.getInputStream());
                    thumbnailId = this.dataStorageService.saveData(new BinaryData(binaryData.getContentType(), Long.valueOf(-1L), thumbnailStream), "thumbnail-".concat(this.file.getName()), metadata);
                    binaryData = new BinaryData(binaryData.getContentType(), binaryData.getLength(), this.file.getInputStream());
                }
                catch (IOException e) {
                    LOGGER.error("Thumbnail is not created for log [{}]. Error:\n{}", (Object)this.log.getId(), (Object)e);
                }
            }
            String dataId = this.dataStorageService.saveData(binaryData, this.file.getName(), metadata);
            BinaryContent content = new BinaryContent();
            content.setBinaryDataId(dataId);
            content.setContentType(binaryData.getContentType());
            if (null != thumbnailId) {
                content.setThumbnailId(thumbnailId);
            }
            this.log.setBinaryContent(content);
            this.logRepository.save((Object)this.log);
        }
        catch (IOException e) {
            LOGGER.error("Unable to save binary data", (Throwable)e);
        }
        finally {
            if (this.file instanceof CommonsMultipartFile) {
                ((CommonsMultipartFile)this.file).getFileItem().delete();
            }
        }
    }

    public SaveBinaryDataJob withFile(MultipartFile file) {
        Preconditions.checkNotNull((Object)file, (Object)"Binary data shouldn't be null");
        this.file = file;
        return this;
    }

    public SaveBinaryDataJob withLog(Log log) {
        Preconditions.checkNotNull((Object)log, (Object)"Log shouldn't be null");
        this.log = log;
        return this;
    }

    public SaveBinaryDataJob withProject(String projectName) {
        Preconditions.checkNotNull((Object)projectName, (Object)"Project name shouldn't be null");
        this.project = projectName;
        return this;
    }

    private boolean isImage(String contentType) {
        return contentType != null && contentType.contains("image");
    }
}

