/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import java.time.Duration;
import java.util.stream.Stream;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CleanScreenshotsJob
implements Job {
    @Autowired
    private DataStorage gridFS;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LogRepository logRepository;

    public void execute(JobExecutionContext context) {
        try (Stream projects = this.projectRepository.streamAllIdsAndConfiguration();){
            projects.forEach(project -> {
                Duration period = Duration.ofDays(KeepScreenshotsDelay.findByName((String)project.getConfiguration().getKeepScreenshots()).getDays());
                if (!period.isZero()) {
                    this.gridFS.findModifiedLaterAgo(period, project.getId()).forEach(file -> {
                        this.gridFS.deleteData(file.getId().toString());
                        this.logRepository.removeBinaryContent(file.getId().toString());
                    });
                }
            });
        }
    }
}

