/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.info;

import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.info.ExtensionContributor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerSettingsInfoContributor
implements ExtensionContributor {
    private static final String ANALYTICS_KEY = "analytics";
    private static final String INSTANCE_ID_KEY = "instanceId";
    private final ServerSettingsRepository settingsRepository;

    @Autowired
    public ServerSettingsInfoContributor(ServerSettingsRepository settingsRepository) {
        this.settingsRepository = settingsRepository;
    }

    public Map<String, ?> contribute() {
        HashMap info = new HashMap();
        Optional<Object> serverSettings = Optional.ofNullable(this.settingsRepository.findOne((Serializable)((Object)"default")));
        serverSettings.flatMap(settings -> Optional.ofNullable(settings.getAnalyticsDetails())).ifPresent(it -> info.put(ANALYTICS_KEY, it));
        serverSettings.flatMap(settings -> Optional.ofNullable(settings.getInstanceId())).ifPresent(instanceId -> info.put(INSTANCE_ID_KEY, instanceId));
        return info;
    }
}

