/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.events.FilterDeletedEvent;
import com.epam.ta.reportportal.events.FilterUpdatedEvent;
import com.epam.ta.reportportal.events.FiltersCreatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UserFilterActivityHandler {
    private ActivityRepository activityRepository;

    @Autowired
    public UserFilterActivityHandler(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onFilterCreate(FiltersCreatedEvent event) {
        List filters = event.getCreatedFilters();
        filters.forEach(filter -> {
            Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.CREATE_FILTER).addObjectType(ActivityObjectType.USER_FILTER).addObjectName(filter.getName()).addProjectRef(event.getProjectRef()).addUserRef(event.getCreatedBy()).addLoggedObjectRef(filter.getId()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)filter.getName()))).get();
            this.activityRepository.save((Object)activityLog);
        });
    }

    @EventListener
    public void onFilterUpdate(FilterUpdatedEvent event) {
        UserFilter before = (UserFilter)event.getBefore();
        UserFilter after = (UserFilter)event.getAfter();
        ArrayList history = Lists.newArrayList();
        if (before != null) {
            EventHandlerUtil.processShare((List)history, (Shareable)before, (Boolean)(!after.getAcl().getEntries().isEmpty() ? 1 : 0));
            EventHandlerUtil.processName((List)history, (String)before.getName(), (String)after.getName());
            EventHandlerUtil.processDescription((List)history, (String)before.getDescription(), (String)after.getDescription());
            Activity activityLog = new ActivityBuilder().addProjectRef(after.getProjectName()).addObjectName(after.getName()).addObjectType(ActivityObjectType.USER_FILTER).addActionType(ActivityEventType.UPDATE_FILTER).addLoggedObjectRef(after.getId()).addUserRef(event.getUpdatedBy()).addHistory((List)(!history.isEmpty() ? history : null)).get();
            this.activityRepository.save((Object)activityLog);
        }
    }

    @EventListener
    public void onFilterDelete(FilterDeletedEvent event) {
        UserFilter before = (UserFilter)event.getBefore();
        Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.DELETE_FILTER).addObjectType(ActivityObjectType.USER_FILTER).addObjectName(before.getName()).addProjectRef(before.getProjectName()).addUserRef(event.getRemovedBy()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)before.getName(), (String)""))).get();
        this.activityRepository.save((Object)activityLog);
    }
}

