/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.ActivityEventType;
import com.epam.ta.reportportal.database.entity.item.ActivityObjectType;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.events.DashboardCreatedEvent;
import com.epam.ta.reportportal.events.DashboardDeletedEvent;
import com.epam.ta.reportportal.events.DashboardUpdatedEvent;
import com.epam.ta.reportportal.events.handler.EventHandlerUtil;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.dashboard.CreateDashboardRQ;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DashboardActivityEventHandler {
    @Autowired
    private ActivityRepository activityRepository;

    @EventListener
    public void onDashboardUpdate(DashboardUpdatedEvent event) {
        Dashboard dashboard = event.getDashboard();
        UpdateDashboardRQ updateRQ = event.getUpdateRQ();
        ArrayList history = Lists.newArrayList();
        if (dashboard != null) {
            EventHandlerUtil.processShare((List)history, (Shareable)dashboard, (Boolean)updateRQ.getShare());
            EventHandlerUtil.processName((List)history, (String)dashboard.getName(), (String)updateRQ.getName());
            EventHandlerUtil.processDescription((List)history, (String)dashboard.getDescription(), (String)updateRQ.getDescription());
            if (!history.isEmpty()) {
                Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.UPDATE_DASHBOARD).addObjectType(ActivityObjectType.DASHBOARD).addObjectName(dashboard.getName()).addProjectRef(dashboard.getProjectName()).addLoggedObjectRef(dashboard.getId()).addUserRef(event.getUpdatedBy()).addHistory((List)history).get();
                this.activityRepository.save((Object)activityLog);
            }
        }
    }

    @EventListener
    public void onDashboardCreate(DashboardCreatedEvent event) {
        CreateDashboardRQ createDashboardRQ = event.getCreateDashboardRQ();
        Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.CREATE_DASHBOARD).addObjectType(ActivityObjectType.DASHBOARD).addObjectName(createDashboardRQ.getName()).addProjectRef(event.getProjectRef()).addUserRef(event.getCreatedBy()).addLoggedObjectRef(event.getDashboardId()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)"", (String)createDashboardRQ.getName()))).get();
        this.activityRepository.save((Object)activityLog);
    }

    @EventListener
    public void onDashboardDelete(DashboardDeletedEvent event) {
        Dashboard dashboard = (Dashboard)event.getBefore();
        Activity activityLog = new ActivityBuilder().addActionType(ActivityEventType.DELETE_DASHBOARD).addObjectType(ActivityObjectType.DASHBOARD).addObjectName(dashboard.getName()).addProjectRef(dashboard.getProjectName()).addUserRef(event.getRemovedBy()).addHistory(Collections.singletonList(EventHandlerUtil.createHistoryField((String)"name", (String)dashboard.getName(), (String)""))).get();
        this.activityRepository.save((Object)activityLog);
    }
}

