/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.demo_data.DemoDashboardsService;
import com.epam.ta.reportportal.demo_data.DemoDataFacade;
import com.epam.ta.reportportal.demo_data.DemoDataFacadeFactory;
import com.epam.ta.reportportal.demo_data.DemoDataRq;
import com.epam.ta.reportportal.demo_data.DemoDataRs;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class DemoDataService {
    private final DemoDashboardsService demoDashboardsService;
    private final DemoDataFacadeFactory demoDataFacadeFactory;
    private final ProjectRepository projectRepository;

    @Autowired
    DemoDataService(DemoDashboardsService demoDashboardsService, ProjectRepository projectRepository, DemoDataFacadeFactory demoDataFacadeFactory) {
        this.demoDashboardsService = demoDashboardsService;
        this.projectRepository = projectRepository;
        this.demoDataFacadeFactory = demoDataFacadeFactory;
    }

    DemoDataRs generate(DemoDataRq rq, String projectName, String user) {
        DemoDataRs demoDataRs = new DemoDataRs();
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        List postfixes = Optional.ofNullable(project.getMetadata()).map(Project.Metadata::getDemoDataPostfix).orElse(new ArrayList());
        if (!Strings.isNullOrEmpty((String)rq.getPostfix())) {
            BusinessRule.expect((Object)rq.getPostfix(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)postfixes))).verify(ErrorType.DEMO_DATA_GENERATION_ERROR, new Object[]{String.format("Postfix %s already used", rq.getPostfix())});
        }
        StatisticsCalculationStrategy statsStrategy = project.getConfiguration().getStatisticsCalculationStrategy();
        DemoDataFacade demoData = this.demoDataFacadeFactory.getDemoDataFacade(statsStrategy);
        List launches = demoData.generateDemoLaunches(rq, user, projectName);
        demoDataRs.setLaunches(launches);
        if (rq.isCreateDashboard()) {
            Dashboard demoDashboard = this.demoDashboardsService.generate(rq, user, projectName);
            demoDataRs.setDashboards(Collections.singletonList(demoDashboard.getId()));
        }
        this.projectRepository.addDemoDataPostfix(project.getName(), rq.getPostfix());
        return demoDataRs;
    }
}

