/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.widget.IUpdateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.events.WidgetUpdatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateWidgetHandler
implements IUpdateWidgetHandler {
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private Provider<WidgetBuilder> widgetBuilder;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;
    @Autowired
    private SharingService sharingService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public OperationCompletionRS updateWidget(String widgetId, WidgetRQ updateRQ, String userName, String projectName, UserRole userRole) {
        Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
        Widget beforeUpdate = (Widget)SerializationUtils.clone((Serializable)widget);
        BusinessRule.expect((Object)widget, (Predicate)Predicates.notNull()).verify(ErrorType.WIDGET_NOT_FOUND, new Object[]{widgetId});
        this.validateWidgetAccess(projectName, userName, userRole, widget, updateRQ);
        Widget newWidget = this.updateWidget(widget, updateRQ, userName, projectName);
        this.widgetRepository.save((Object)newWidget);
        this.eventPublisher.publishEvent((Object)new WidgetUpdatedEvent(beforeUpdate, updateRQ, userName));
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' successfully updated.");
    }

    private Widget updateWidget(Widget widget, WidgetRQ updateRQ, String userName, String projectName) {
        GadgetTypes gadget = (GadgetTypes)GadgetTypes.findByName((String)updateRQ.getContentParameters().getGadget()).get();
        UserFilter newFilter = null;
        if (!WidgetUtils.withoutFilter.containsKey(gadget)) {
            newFilter = this.filterRepository.findOneLoadACL(userName, updateRQ.getFilterId(), projectName);
            WidgetUtils.checkApplyingFilter((UserFilter)newFilter, (String)updateRQ.getFilterId(), (String)userName);
        }
        Widget newWidget = (Widget)((WidgetBuilder)this.widgetBuilder.get()).addWidgetRQ(updateRQ).addDescription(updateRQ.getDescription()).build();
        this.validateWidgetFields(newWidget, newFilter, gadget);
        this.updateWidget(widget, newWidget, newFilter);
        this.shareIfRequired(updateRQ.getShare(), widget, userName, projectName, newFilter);
        return widget;
    }

    private void validateWidgetAccess(String projectName, String userName, UserRole userRole, Widget widget, WidgetRQ updateRQ) {
        List widgetList = this.widgetRepository.findByProjectAndUser(projectName, userName);
        if (null != updateRQ.getName() && !widget.getName().equals(updateRQ.getName())) {
            WidgetUtils.checkUniqueName((String)updateRQ.getName(), (List)widgetList);
        }
        AclUtils.isAllowedToEdit((Acl)widget.getAcl(), (String)userName, (Map)this.projectRepository.findProjectRoles(userName), (String)widget.getName(), (UserRole)userRole);
        BusinessRule.expect((Object)widget.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
    }

    private void shareIfRequired(Boolean isShare, Widget widget, String userName, String projectName, UserFilter newFilter) {
        if (isShare != null) {
            if (null != newFilter) {
                AclUtils.isPossibleToRead((Acl)newFilter.getAcl(), (String)userName, (String)projectName);
            }
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Widget[]{widget}), userName, projectName, isShare.booleanValue());
        }
    }

    private void updateWidget(Widget oldWidget, Widget newValues, UserFilter filter) {
        if (newValues.getContentOptions() != null) {
            oldWidget.setContentOptions(newValues.getContentOptions());
        }
        if (newValues.getName() != null) {
            oldWidget.setName(newValues.getName());
        }
        if (filter != null) {
            oldWidget.setApplyingFilterId(filter.getId());
        }
        oldWidget.setDescription(newValues.getDescription());
    }

    private void validateWidgetFields(Widget newWidget, UserFilter newFilter, GadgetTypes gadget) {
        ContentOptions contentOptions = newWidget.getContentOptions();
        Class target = WidgetUtils.withoutFilter.containsKey(gadget) ? (Class)WidgetUtils.withoutFilter.get(gadget) : newFilter.getFilter().getTarget();
        if (TestItem.class.equals((Object)target)) {
            this.removeLaunchSpecificFields(contentOptions);
        }
        WidgetUtils.validateWidgetDataType((String)contentOptions.getType(), (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
        WidgetUtils.validateGadgetType((String)contentOptions.getGadgetType(), (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
        CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(target);
        if (null != contentOptions.getContentFields()) {
            WidgetUtils.validateFields((Iterable)contentOptions.getContentFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
        }
        if (null != contentOptions.getMetadataFields()) {
            WidgetUtils.validateFields((Iterable)contentOptions.getMetadataFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
        }
    }

    private void removeLaunchSpecificFields(ContentOptions contentOptions) {
        if (null != contentOptions.getMetadataFields() && contentOptions.getMetadataFields().contains("number")) {
            contentOptions.getMetadataFields().remove("number");
        }
        if (null != contentOptions.getContentFields() && contentOptions.getContentFields().contains("number")) {
            contentOptions.getContentFields().remove("number");
        }
        if (null != contentOptions.getContentFields() && contentOptions.getContentFields().contains("user")) {
            contentOptions.getContentFields().remove("user");
        }
    }
}

