/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.widget.IGetWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategyLatest;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.WidgetResourceAssembler;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.widget.WidgetPreviewRQ;
import com.epam.ta.reportportal.ws.model.widget.WidgetResource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetWidgetHandler
implements IGetWidgetHandler {
    private WidgetRepository widgetRepository;
    private WidgetResourceAssembler resourceAssembler;
    private UserFilterRepository userFilterRepository;
    private Map<GadgetTypes, BuildFilterStrategy> buildFilterStrategy;
    private final Function<Widget, SharedEntity> TO_SHARED_ENTITY = widget -> {
        SharedEntity sharedEntity = new SharedEntity();
        sharedEntity.setId(widget.getId());
        sharedEntity.setName(widget.getName());
        Optional.ofNullable(widget.getAcl()).ifPresent(acl -> sharedEntity.setOwner(acl.getOwnerUserId()));
        sharedEntity.setDescription(widget.getDescription());
        return sharedEntity;
    };

    @Autowired
    public void setWidgetRepository(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Autowired
    public void setWidgetResourceAssembler(WidgetResourceAssembler widgetResourceAssembler) {
        this.resourceAssembler = widgetResourceAssembler;
    }

    @Autowired
    public void setUserFilterRepository(UserFilterRepository userFilterRepository) {
        this.userFilterRepository = userFilterRepository;
    }

    @Autowired
    @Qualifier(value="buildFilterStrategy")
    public void setBuildFilterStrategy(Map<GadgetTypes, BuildFilterStrategy> buildFilterStrategy) {
        this.buildFilterStrategy = buildFilterStrategy;
    }

    public WidgetResource getWidget(String widgetId, String userName, String project) {
        WidgetResource widgetResource;
        Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
        BusinessRule.expect((Object)widget, (Predicate)Predicates.notNull()).verify(ErrorType.WIDGET_NOT_FOUND, new Object[]{widgetId});
        BusinessRule.expect((Object)widget.getProjectName(), (Predicate)Predicates.equalTo((Object)project)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        if (!AclUtils.isPossibleToReadResource((Acl)widget.getAcl(), (String)userName, (String)project)) {
            Widget emptyModel = new Widget();
            emptyModel.setName(widget.getName());
            emptyModel.setOwner(widget.getAcl().getOwnerUserId());
            widgetResource = this.resourceAssembler.toResource(emptyModel);
        } else {
            widgetResource = this.resourceAssembler.toResource(widget);
            Optional userFilter = this.findUserFilter(widget.getApplyingFilterId());
            if (this.isFilterUnShared(userName, project, userFilter)) {
                widgetResource.setContent(new HashMap());
            } else {
                widgetResource.setContent(this.loadContentByFilterType(userFilter, project, widget.getContentOptions()));
            }
        }
        return widgetResource;
    }

    public Iterable<SharedEntity> getSharedWidgetNames(String userName, String projectName, Pageable pageable) {
        List<String> fields = Arrays.asList("_id", "name", "acl.ownerUserId");
        Page page = this.widgetRepository.findSharedEntities(projectName, fields, Shareable.NAME_OWNER_SORT, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)this.TO_SHARED_ENTITY).apply(page);
    }

    public Iterable<WidgetResource> getSharedWidgetsList(String userName, String projectName, Pageable pageable) {
        List<String> fields = Arrays.asList("_id", "name", "description", "acl.ownerUserId", "contentOptions.gadgetType", "contentOptions.contentFields", "acl.entries");
        Page widgets = this.widgetRepository.findSharedEntities(projectName, fields, Shareable.NAME_OWNER_SORT, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)WidgetConverter.TO_RESOURCE).apply(widgets);
    }

    public List<String> getWidgetNames(String projectName, String userName) {
        return this.widgetRepository.findByProjectAndUser(projectName, userName).stream().map(Widget::getName).collect(Collectors.toList());
    }

    public Map<String, ?> getWidgetPreview(String projectName, String userName, WidgetPreviewRQ previewRQ) {
        WidgetUtils.validateWidgetDataType((String)previewRQ.getContentParameters().getType(), (ErrorType)ErrorType.BAD_REQUEST_ERROR);
        WidgetUtils.validateGadgetType((String)previewRQ.getContentParameters().getGadget(), (ErrorType)ErrorType.BAD_REQUEST_ERROR);
        Optional userFilter = this.findUserFilter(previewRQ.getFilterId());
        if (this.isFilterUnShared(userName, projectName, userFilter)) {
            return Collections.emptyMap();
        }
        ContentOptions contentOptions = ((Widget)new WidgetBuilder().addContentParameters(previewRQ.getContentParameters()).build()).getContentOptions();
        return this.loadContentByFilterType(userFilter, projectName, contentOptions);
    }

    public Iterable<WidgetResource> searchSharedWidgets(String term, String projectName, Pageable pageable) {
        Page entities = this.widgetRepository.findSharedEntitiesByName(projectName, term, pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter((Function)WidgetConverter.TO_RESOURCE).apply(entities);
    }

    private boolean isRequireUserFilter(GadgetTypes gadgetType, Optional<UserFilter> userFilter) {
        return userFilter.isPresent() || gadgetType == GadgetTypes.ACTIVITY || gadgetType == GadgetTypes.MOST_FAILED_TEST_CASES || gadgetType == GadgetTypes.PASSING_RATE_PER_LAUNCH;
    }

    private boolean isFilterUnShared(String userName, String project, Optional<UserFilter> userFilter) {
        return userFilter.isPresent() && !AclUtils.isPossibleToReadResource((Acl)userFilter.get().getAcl(), (String)userName, (String)project);
    }

    Map<String, ?> loadContentByFilterType(Optional<UserFilter> userFilter, String projectName, ContentOptions contentOptions) {
        Map content;
        if (userFilter.isPresent() && Log.class.equals((Object)userFilter.get().getFilter().getTarget())) {
            content = new HashMap();
        } else {
            BuildFilterStrategy filterStrategy = (BuildFilterStrategy)this.buildFilterStrategy.get(GadgetTypes.findByName((String)contentOptions.getGadgetType()).get());
            BusinessRule.expect((Object)filterStrategy, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{Suppliers.formattedSupplier((String)"Unknown gadget type: '{}'.", (Object[])new Object[]{contentOptions.getGadgetType()})});
            content = contentOptions.getWidgetOptions() != null && contentOptions.getWidgetOptions().containsKey("latest") ? ((BuildFilterStrategyLatest)filterStrategy).loadContentOfLatest((UserFilter)userFilter.orElse(null), contentOptions, projectName) : filterStrategy.buildFilterAndLoadContent((UserFilter)userFilter.orElse(null), contentOptions, projectName);
        }
        return content;
    }

    private Optional<UserFilter> findUserFilter(String filterId) {
        return Optional.ofNullable(filterId == null ? null : (UserFilter)this.userFilterRepository.findOne((Serializable)((Object)filterId)));
    }
}

