/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.history;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.core.widget.content.history.HistoryTestCasesStrategy;
import com.epam.ta.reportportal.core.widget.content.history.MostFailedTestCasesFilterStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.history.status.MostFailedHistory;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MostFailedTestCasesFilterStrategy
extends HistoryTestCasesStrategy {
    private static final String MOST_FAILED = "most_failed";
    @Autowired
    private TestItemRepository itemRepository;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;

    public Map<String, List<?>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        String criteria = this.getCriteria(contentOptions);
        List launchHistory = this.getLaunchHistory(contentOptions, projectName);
        if (CollectionUtils.isEmpty((Collection)launchHistory)) {
            return Collections.emptyMap();
        }
        List ids = launchHistory.stream().map(Launch::getId).collect(Collectors.toList());
        List history = this.itemRepository.getMostFailedItemHistory(ids, criteria, 20);
        if (CollectionUtils.isEmpty((Collection)history)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<?>> result = new HashMap(2);
        result = this.processHistory(result, history);
        this.addLastLaunch(result, launchHistory);
        return result;
    }

    private Map<String, List<?>> processHistory(Map<String, List<?>> result, List<MostFailedHistory> itemStatusHistory) {
        result.put(MOST_FAILED, itemStatusHistory.stream().map(arg_0 -> this.processItem(arg_0)).collect(Collectors.toList()));
        return result;
    }

    private MostFailedHistoryObject processItem(MostFailedHistory historyItem) {
        MostFailedHistoryObject mostFailed = new MostFailedHistoryObject(null);
        mostFailed.setUniqueId(historyItem.getUniqueId());
        mostFailed.setName(historyItem.getName());
        mostFailed.setTotal(historyItem.getTotal());
        mostFailed.setFailedCount(historyItem.getFailed());
        mostFailed.setPercentage(this.countPercentage(historyItem.getFailed(), historyItem.getTotal()));
        Date date = null;
        List historyEntries = Optional.ofNullable(historyItem.getStatusHistory()).orElse(Collections.emptyList());
        ArrayList<Boolean> statuses = new ArrayList<Boolean>(historyEntries.size());
        for (MostFailedHistory.HistoryEntry entry : historyEntries) {
            boolean isFailed = false;
            if (entry.getCriteriaAmount() > 0) {
                date = entry.getStartTime();
                isFailed = true;
            }
            statuses.add(isFailed);
        }
        mostFailed.setLastTime(date);
        mostFailed.setIsFailed(statuses);
        return mostFailed;
    }

    private String getCriteria(ContentOptions contentOptions) {
        String criteria = null;
        if (null != contentOptions.getContentFields() && contentOptions.getContentFields().size() == 1) {
            criteria = (String)WidgetContentProvider.transformToDBStyle((CriteriaMap)this.criteriaMapFactory.getCriteriaMap(Launch.class), (List)contentOptions.getContentFields()).get(0);
        }
        BusinessRule.expect(criteria, Objects::nonNull).verify(ErrorType.BAD_REQUEST_ERROR, new Object[0]);
        return criteria;
    }
}

