/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.history;

import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class HistoryTestCasesStrategy
implements BuildFilterStrategy {
    private static final String LAUNCH_NAME_FIELD = "launchNameFilter";
    private static final String LAST_FOUND_LAUNCH = "lastLaunch";
    static final int RESULTED_MAP_SIZE = 2;
    static final int ITEMS_COUNT_VALUE = 20;
    @Autowired
    protected LaunchRepository launchRepository;
    @Autowired
    private ITestItemsHistoryService historyServiceStrategy;

    List<Launch> getLaunchHistory(ContentOptions contentOptions, String projectName) {
        if (contentOptions.getWidgetOptions() == null || contentOptions.getWidgetOptions().get(LAUNCH_NAME_FIELD) == null) {
            return Collections.emptyList();
        }
        Optional lastLaunchForProject = this.launchRepository.findLastLaunch(projectName, (String)((List)contentOptions.getWidgetOptions().get(LAUNCH_NAME_FIELD)).get(0), Mode.DEFAULT.name());
        if (!lastLaunchForProject.isPresent()) {
            return Collections.emptyList();
        }
        List launchHistory = this.historyServiceStrategy.loadLaunches(contentOptions.getItemsCount(), ((Launch)lastLaunchForProject.get()).getId(), projectName, false);
        if (launchHistory.isEmpty()) {
            return Collections.emptyList();
        }
        return launchHistory;
    }

    void addLastLaunch(Map<String, List<?>> result, List<Launch> launches) {
        if (!CollectionUtils.isEmpty(launches)) {
            Launch last = launches.get(0);
            ChartObject lastLaunch = new ChartObject();
            lastLaunch.setName(last.getName());
            lastLaunch.setNumber(last.getNumber().toString());
            lastLaunch.setId(last.getId());
            result.put(LAST_FOUND_LAUNCH, Collections.singletonList(lastLaunch));
        }
    }

    String countPercentage(int amount, int total) {
        return String.format("%.2f", (double)amount / (double)total * 100.0) + "%";
    }
}

