/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.settings.IUpdateProjectSettingsHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.events.DefectTypeUpdatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.project.config.UpdateIssueSubTypeRQ;
import com.epam.ta.reportportal.ws.model.project.config.UpdateOneIssueSubTypeRQ;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateProjectSettingsHandler
implements IUpdateProjectSettingsHandler {
    private ProjectRepository projectRepo;
    private ApplicationEventPublisher eventPublisher;

    @Autowired
    public UpdateProjectSettingsHandler(ProjectRepository projectRepo, ApplicationEventPublisher eventPublisher) {
        this.projectRepo = projectRepo;
        this.eventPublisher = eventPublisher;
    }

    public OperationCompletionRS updateProjectIssueSubType(String projectName, String user, UpdateIssueSubTypeRQ rq) {
        BusinessRule.expect((Object)(rq.getIds().size() > 0 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Please specify at least one item data for update."});
        Project project = (Project)this.projectRepo.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        BusinessRule.expect((Object)project.getConfiguration(), (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_SETTINGS_NOT_FOUND, new Object[]{projectName});
        rq.getIds().stream().forEach(r -> this.validateAndUpdate(r, project.getConfiguration()));
        try {
            this.projectRepo.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during update of custom project issue sub-type", (Throwable)e);
        }
        this.eventPublisher.publishEvent((Object)new DefectTypeUpdatedEvent(projectName, user, rq));
        return new OperationCompletionRS("Issue sub-type(s) was updated successfully.");
    }

    private static <T> Collector<T, ?, T> findOneCollector(String id) {
        return Collectors.collectingAndThen(Collectors.toList(), shouldBeOne -> {
            if (shouldBeOne.size() != 1) {
                throw new ReportPortalException(String.format("No such issue sub-type found for id='%s'", id));
            }
            return shouldBeOne.get(0);
        });
    }

    private void validateAndUpdate(UpdateOneIssueSubTypeRQ one, Project.Configuration settings) {
        TestItemIssueType expectedType = TestItemIssueType.fromValue((String)one.getTypeRef());
        BusinessRule.expect((Object)expectedType, (Predicate)Predicates.notNull()).verify(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{one.getTypeRef()});
        StatisticSubType exist = settings.getByLocator(one.getId());
        BusinessRule.expect((Object)exist, (Predicate)Predicates.notNull()).verify(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{one.getId()});
        BusinessRule.expect((Object)(exist.getTypeRef().equals(expectedType.getValue()) || exist.getTypeRef().equals("total") ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"You cannot change sub-type references to global type."});
        if (Sets.newHashSet((Object[])new String[]{TestItemIssueType.AUTOMATION_BUG.getLocator(), TestItemIssueType.PRODUCT_BUG.getLocator(), TestItemIssueType.SYSTEM_ISSUE.getLocator(), TestItemIssueType.NO_DEFECT.getLocator(), TestItemIssueType.TO_INVESTIGATE.getLocator(), "total"}).contains(exist.getLocator())) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"You cannot edit predefined global issue types."});
        }
        StatisticSubType type = new StatisticSubType(one.getId(), one.getTypeRef(), one.getLongName(), one.getShortName(), one.getColor());
        settings.setByLocator(type);
    }
}

