/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.project.IGetProjectHandler;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.ProjectResourceAssembler;
import com.epam.ta.reportportal.ws.converter.UserResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetProjectHandler
implements IGetProjectHandler {
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ExternalSystemRepository externalSystemRepository;
    @Autowired
    private UserResourceAssembler userResourceAssembler;
    @Autowired
    private ProjectResourceAssembler projectResourceAssembler;

    @Autowired
    public GetProjectHandler(ProjectRepository prjRepo) {
        this.projectRepository = (ProjectRepository)Preconditions.checkNotNull((Object)prjRepo);
    }

    public Iterable<UserResource> getProjectUsers(String project, @FilterFor(value=User.class) Filter filter, Pageable pageable) {
        Project dbProject = (Project)this.projectRepository.findOne((Serializable)((Object)project));
        if (null == dbProject || null == dbProject.getUsers()) {
            return Collections.emptyList();
        }
        String criteria = dbProject.getUsers().stream().map(Project.UserConfig::getLogin).collect(Collectors.joining(","));
        filter.addCondition(new FilterCondition(Condition.IN, false, criteria, "login"));
        Page users = this.userRepository.findByFilterExcluding((Queryable)filter, pageable, new String[]{"email"});
        return this.userResourceAssembler.toPagedResources(users, dbProject);
    }

    public List<String> getUserNames(String project, String value) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.projectRepository.findProjectUsers(project, value);
    }

    public com.epam.ta.reportportal.ws.model.Page<UserResource> getUserNames(String value, Pageable pageable) {
        BusinessRule.expect((Object)(value.length() >= 1 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.userResourceAssembler.toPagedResources(this.userRepository.searchForUserLogin(value, pageable));
    }

    public ProjectResource getProject(String project) {
        Project dbProject = (Project)this.projectRepository.findOne((Serializable)((Object)project));
        BusinessRule.expect((Object)dbProject, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{project});
        if (null != dbProject.getConfiguration().getExternalSystem() && !dbProject.getConfiguration().getExternalSystem().isEmpty() && null != dbProject.getConfiguration().getSubTypes()) {
            Iterable systems = this.externalSystemRepository.findAll((Iterable)dbProject.getConfiguration().getExternalSystem());
            return this.projectResourceAssembler.toResource(dbProject, systems);
        }
        return this.projectResourceAssembler.toResource(dbProject);
    }

    public OperationCompletionRS isProjectsAvailable() {
        BusinessRule.expect((Object)(this.projectRepository.count() > 0L ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]);
        return new OperationCompletionRS("MongoDB project collection available");
    }

    public List<String> getAllProjectNames() {
        return this.projectRepository.findAllProjectNames();
    }
}

