/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.ILogIndexer;
import com.epam.ta.reportportal.core.item.TestItemUniqueIdGenerator;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategy;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategyFactory;
import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.launch.IMergeLaunchHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.LaunchMetaInfoRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MergeLaunchHandler
implements IMergeLaunchHandler {
    private TestItemRepository testItemRepository;
    private ProjectRepository projectRepository;
    private LaunchRepository launchRepository;
    private UserRepository userRepository;
    @Autowired
    private MergeStrategyFactory mergeStrategyFactory;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private LaunchMetaInfoRepository launchCounter;
    @Autowired
    private TestItemUniqueIdGenerator identifierGenerator;
    @Autowired
    private ILogIndexer logIndexer;

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    public LaunchResource mergeLaunches(String projectName, String userName, MergeLaunchesRQ rq) {
        User user = (User)this.userRepository.findOne((Serializable)((Object)userName));
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Set launchesIds = rq.getLaunches();
        BusinessRule.expect((Object)(launchesIds.size() > 1 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{rq.getLaunches()});
        List launchesList = this.launchRepository.find((Collection)launchesIds);
        boolean hasRetries = launchesList.stream().anyMatch(it -> it.getHasRetries() != null);
        this.validateMergingLaunches(launchesList, user, project);
        Launch launch = this.createResultedLaunch(projectName, userName, rq, hasRetries);
        boolean isNameChanged = !launch.getName().equals(((Launch)launchesList.get(0)).getName());
        this.updateChildrenOfLaunches(launch.getId(), rq.getLaunches(), rq.isExtendSuitesDescription(), isNameChanged);
        MergeStrategyType type = MergeStrategyType.fromValue((String)rq.getMergeStrategyType());
        BusinessRule.expect((Object)type, (Predicate)Predicates.notNull()).verify(ErrorType.UNSUPPORTED_MERGE_STRATEGY_TYPE, new Object[]{type});
        if (!type.equals((Object)MergeStrategyType.BASIC)) {
            MergeStrategy strategy = this.mergeStrategyFactory.getStrategy(type);
            this.testItemRepository.findWithoutParentByLaunchRef(launch.getId()).stream().collect(Collectors.groupingBy(TestItem::getUniqueId)).entrySet().stream().map(Map.Entry::getValue).filter(items -> items.size() > 1).forEach(items -> strategy.mergeTestItems((TestItem)items.get(0), items.subList(1, items.size())));
        }
        StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy());
        statisticsFacade.recalculateStatistics(launch);
        launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launch.getId()));
        launch.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics()));
        launch.setEndTime(rq.getEndTime());
        this.launchRepository.save((Object)launch);
        this.launchRepository.delete((Collection)launchesIds);
        this.logIndexer.indexLogs(launch.getId(), this.testItemRepository.findItemsNotInIssueType(TestItemIssueType.TO_INVESTIGATE.getLocator(), launch.getId()));
        return (LaunchResource)LaunchConverter.TO_RESOURCE.apply(launch);
    }

    private void validateMergingLaunches(List<Launch> launches, User user, Project project) {
        BusinessRule.expect((Object)launches.size(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)0))).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{launches});
        boolean isUserValidate = !user.getRole().equals((Object)UserRole.ADMINISTRATOR) && !ProjectUtils.findUserConfigByLogin((Project)project, (String)user.getId()).getProjectRole().sameOrHigherThan(ProjectRole.PROJECT_MANAGER);
        launches.forEach(launch -> {
            BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launch});
            BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((Status[])new Status[]{Status.IN_PROGRESS}))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Cannot merge launch '{}' with status '{}'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
            BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)project.getId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to merge launches from different projects."});
            if (isUserValidate) {
                BusinessRule.expect((Object)launch.getUserRef(), (Predicate)Predicates.equalTo((Object)user.getId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not an owner of launches or have less than PROJECT_MANAGER project role."});
            }
        });
    }

    private void updateChildrenOfLaunches(String launchId, Set<String> launches, boolean extendDescription, boolean isNameChanged) {
        List testItems = launches.stream().flatMap(id -> {
            Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)id));
            return this.testItemRepository.findByLaunch(launch).stream().map(item -> {
                item.setLaunchRef(launchId);
                if (isNameChanged && this.identifierGenerator.validate(item.getUniqueId())) {
                    item.setUniqueId(this.identifierGenerator.generate(item));
                }
                if (item.getType().sameLevel(TestItemType.SUITE)) {
                    Supplier newDescription = Suppliers.formattedSupplier((String)((null != item.getItemDescription() ? item.getItemDescription() : "") + (extendDescription ? "\r\n@launch '{} #{}'" : "")), (Object[])new Object[]{launch.getName(), launch.getNumber()});
                    item.setItemDescription((String)newDescription.get());
                }
                return item;
            });
        }).collect(Collectors.toList());
        this.testItemRepository.save(testItems);
    }

    private Launch createResultedLaunch(String projectName, String userName, MergeLaunchesRQ mergeLaunchesRQ, boolean hasRetries) {
        StartLaunchRQ startRQ = new StartLaunchRQ();
        startRQ.setMode(mergeLaunchesRQ.getMode());
        startRQ.setDescription(mergeLaunchesRQ.getDescription());
        startRQ.setName(mergeLaunchesRQ.getName());
        startRQ.setTags(mergeLaunchesRQ.getTags());
        startRQ.setStartTime(mergeLaunchesRQ.getStartTime());
        Launch launch = new LaunchBuilder().addStartRQ(startRQ).addProject(projectName).addStatus(Status.IN_PROGRESS).addUser(userName).get();
        launch.setNumber(Long.valueOf(this.launchCounter.getLaunchNumber(launch.getName(), projectName)));
        launch.setHasRetries(hasRetries ? Boolean.valueOf(true) : null);
        return (Launch)this.launchRepository.save((Object)launch);
    }
}

