/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IFinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.IRetriesLaunchHandler;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.events.LaunchFinishForcedEvent;
import com.epam.ta.reportportal.events.LaunchFinishedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class FinishLaunchHandler
implements IFinishLaunchHandler {
    private static final String LAUNCH_STOP_DESCRIPTION = " stopped";
    private static final String LAUNCH_STOP_TAG = "stopped";
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private IRetriesLaunchHandler retriesLaunchHandler;

    public OperationCompletionRS finishLaunch(String launchId, FinishExecutionRQ finishLaunchRQ, String projectName, String username) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        this.validate(launchId, launch, finishLaunchRQ);
        Project project = this.validateRoles(launch, username, projectName);
        launch.setEndTime(finishLaunchRQ.getEndTime());
        if (!Strings.isNullOrEmpty((String)finishLaunchRQ.getDescription())) {
            launch.setDescription(finishLaunchRQ.getDescription());
        }
        if (!CollectionUtils.isEmpty((Collection)finishLaunchRQ.getTags())) {
            launch.setTags((Set)Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)finishLaunchRQ.getTags()))));
        }
        Optional status = Status.fromValue((String)finishLaunchRQ.getStatus());
        status.ifPresent(providedStatus -> {
            BusinessRule.expect((Object)providedStatus, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)Preconditions.statusIn((Status[])new Status[]{Status.IN_PROGRESS, Status.SKIPPED}))).verify(ErrorType.INCORRECT_FINISH_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Cannot finish launch '{}' with status '{}'", (Object[])new Object[]{launchId, providedStatus})});
            if (Status.PASSED.equals(providedStatus)) {
                BusinessRule.expect((Object)launch.getStatus(), (Predicate)Preconditions.statusIn((Status[])new Status[]{Status.IN_PROGRESS, Status.PASSED})).verify(ErrorType.INCORRECT_FINISH_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Cannot finish launch '{}' with current status '{}' as 'PASSED'", (Object[])new Object[]{launchId, launch.getStatus()})});
                Status fromStatistics = StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics());
                BusinessRule.expect((Object)fromStatistics, (Predicate)Preconditions.statusIn((Status[])new Status[]{Status.IN_PROGRESS, Status.PASSED})).verify(ErrorType.INCORRECT_FINISH_STATUS, new Object[]{Suppliers.formattedSupplier((String)"Cannot finish launch '{}' with calculated automatically status '{}' as 'PASSED'", (Object[])new Object[]{launchId, fromStatistics})});
            }
        });
        launch.setStatus(status.orElse(StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics())));
        try {
            this.launchRepository.save((Object)launch);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while Launch updating.", (Throwable)exp);
        }
        this.eventPublisher.publishEvent((Object)new LaunchFinishedEvent(launch, project));
        return new OperationCompletionRS("Launch with ID = '" + launchId + "' successfully finished.");
    }

    public OperationCompletionRS stopLaunch(String launchId, FinishExecutionRQ finishLaunchRQ, String projectName, String userName) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        this.validateRoles(launch, userName, projectName);
        BusinessRule.expect((Object)launch, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)Preconditions.LAUNCH_FINISHED)).verify(ErrorType.FINISH_LAUNCH_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' already finished with status '{}'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
        launch.setEndTime(finishLaunchRQ.getEndTime());
        if (null != launch.getDescription()) {
            launch.setDescription(launch.getDescription().concat(LAUNCH_STOP_DESCRIPTION));
        } else {
            launch.setDescription(LAUNCH_STOP_DESCRIPTION);
        }
        HashSet<String> newTags = launch.getTags();
        if (null == newTags) {
            newTags = new HashSet<String>();
        }
        newTags.add(LAUNCH_STOP_TAG);
        launch.setTags(newTags);
        launch.setStatus(Status.fromValue((String)finishLaunchRQ.getStatus()).orElse(Status.STOPPED));
        try {
            this.launchRepository.save((Object)launch);
            if (this.launchRepository.hasItems(launch, Status.IN_PROGRESS)) {
                List itemsInProgress = this.testItemRepository.findInStatusItems(Status.IN_PROGRESS.name(), launch.getId());
                this.interruptItems(itemsInProgress);
            }
            this.retriesLaunchHandler.handleRetries(launch);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while Launch updating.", (Throwable)exp);
        }
        this.eventPublisher.publishEvent((Object)new LaunchFinishForcedEvent(launch, userName));
        return new OperationCompletionRS("Launch with ID = '" + launchId + "' successfully stopped.");
    }

    public List<OperationCompletionRS> stopLaunch(BulkRQ<FinishExecutionRQ> bulkRQ, String projectName, String userName) {
        return bulkRQ.getEntities().entrySet().stream().map(entry -> this.stopLaunch((String)entry.getKey(), (FinishExecutionRQ)entry.getValue(), projectName, userName)).collect(Collectors.toList());
    }

    private void validate(String launchId, Launch launch, FinishExecutionRQ finishExecutionRQ) {
        BusinessRule.expect((Object)launch, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)Preconditions.LAUNCH_FINISHED)).verify(ErrorType.FINISH_LAUNCH_NOT_ALLOWED, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' already finished with status '{}'", (Object[])new Object[]{launch.getId(), launch.getStatus()})});
        BusinessRule.expect((Object)finishExecutionRQ, (Predicate)Preconditions.finishSameTimeOrLater((Date)launch.getStartTime())).verify(ErrorType.FINISH_TIME_EARLIER_THAN_START_TIME, new Object[]{finishExecutionRQ.getEndTime(), launch.getStartTime(), launchId});
        List items = this.testItemRepository.findByLaunch(launch);
        BusinessRule.expect((Object)items, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)Preconditions.HAS_IN_PROGRESS_ITEMS)).verify(ErrorType.FINISH_LAUNCH_NOT_ALLOWED, new Object[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private Project validateRoles(Launch launch, String userName, String projectName) {
        User user = (User)this.userRepository.findOne((Serializable)((Object)userName));
        BusinessRule.expect((Object)user, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{userName});
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (user.getRole() != UserRole.ADMINISTRATOR && !user.getId().equalsIgnoreCase(launch.getUserRef())) {
            BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)user.getId());
            BusinessRule.expect((Object)userConfig, (Predicate)Preconditions.hasProjectRoles(Collections.singletonList(ProjectRole.PROJECT_MANAGER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        return project;
    }

    private List<TestItem> getInProgressItems(List<TestItem> items) {
        return items.stream().filter(descendant -> Status.IN_PROGRESS.equals((Object)descendant.getStatus())).collect(Collectors.toList());
    }

    private void interruptItems(List<TestItem> testItems) {
        testItems.forEach(arg_0 -> this.interruptItem(arg_0));
    }

    private void interruptItem(TestItem item) {
        if (!Status.INTERRUPTED.equals((Object)item.getStatus())) {
            Project project;
            item.setStatus(Status.INTERRUPTED);
            item.setEndTime(Calendar.getInstance().getTime());
            item = (TestItem)this.testItemRepository.save((Object)item);
            if (!item.hasChilds() && !Predicates.IS_RETRY.test(item) && null != (item = this.statisticsFacadeFactory.getStatisticsFacade((project = (Project)this.projectRepository.findOne((Serializable)((Object)((Launch)this.launchRepository.findOne((Serializable)((Object)item.getLaunchRef()))).getProjectRef()))).getConfiguration().getStatisticsCalculationStrategy()).updateExecutionStatistics(item)).getIssue()) {
                item = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(item);
            }
            if (null != item.getParent()) {
                this.interruptItem((TestItem)this.testItemRepository.findOne((Serializable)((Object)item.getParent())));
            }
        }
    }

    static /* synthetic */ List access$000(FinishLaunchHandler x0, List x1) {
        return x0.getInProgressItems(x1);
    }
}

