/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper;

import com.epam.ta.reportportal.core.jasper.TestItemPojo;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jasperDataProvider")
public class JasperDataProvider {
    private static final String PREFIX = "    ";
    private TestItemRepository testItemRepository;

    @Autowired
    public JasperDataProvider(TestItemRepository testItemRepository) {
        this.testItemRepository = (TestItemRepository)Preconditions.checkNotNull((Object)testItemRepository);
    }

    public List<TestItemPojo> getReportSource(Launch launch) {
        List<Object> result = Collections.emptyList();
        List ownedItems = this.testItemRepository.findByLaunch(launch);
        if (ownedItems.size() > 0) {
            Map<List, List<TestItem>> grouped = ownedItems.stream().map(JasperDataProvider::adjustName).collect(Collectors.groupingBy(TestItem::getPath));
            List prepared = this.processLaunchTree(grouped, (List)Lists.newArrayList());
            result = prepared.stream().map(TestItemPojo::new).collect(Collectors.toList());
        }
        return result;
    }

    private List<TestItem> processLaunchTree(Map<List<String>, List<TestItem>> input, List<TestItem> processing) {
        LinkedHashMap<List<String>, List<TestItem>> c = new LinkedHashMap<List<String>, List<TestItem>>(input);
        ArrayList currentKey = Lists.newArrayList();
        if (((List)c.get(Lists.newArrayList())).size() == 0) {
            return processing;
        }
        TestItem zero = (TestItem)((List)c.get(Lists.newArrayList())).get(0);
        currentKey.add(zero.getId());
        if (!processing.contains(zero)) {
            processing.add(zero);
        }
        while (null != c.get(currentKey) && ((List)c.get(currentKey)).size() > 0) {
            List value = (List)c.get(currentKey);
            TestItem first = (TestItem)value.get(0);
            if (!first.hasChilds()) {
                value.stream().forEach(v -> {
                    if (!processing.contains(v)) {
                        processing.add((TestItem)v);
                    }
                });
                c.remove(currentKey);
                continue;
            }
            if (!processing.contains(first)) {
                processing.add(first);
            }
            currentKey.add(first.getId());
        }
        c.remove(currentKey);
        String last = (String)currentKey.get(currentKey.size() - 1);
        currentKey.remove(last);
        c.put(currentKey, ((List)c.get(currentKey)).stream().filter(f -> !f.getId().equals(last)).collect(Collectors.toList()));
        return this.processLaunchTree(c, processing);
    }

    private static TestItem adjustName(TestItem input) {
        StringBuilder sb = new StringBuilder(StringUtils.repeat((String)PREFIX, (int)input.getPath().size()));
        input.setName(sb.append(input.getName()).toString());
        return input;
    }
}

