/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.client;

import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public final class ClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtils.class);
    static final String ANALYZER_KEY = "analyzer";
    static final String ANALYZER_PRIORITY = "analyzer_priority";
    static final String ANALYZER_INDEX = "analyzer_index";
    static final ToIntFunction<ServiceInstance> SERVICE_PRIORITY = it -> {
        try {
            return Integer.parseInt((String)it.getMetadata().get(ANALYZER_PRIORITY));
        }
        catch (Exception e) {
            LOGGER.warn("Incorrect specification of tag '{}' for service '{}'. Using the lowest priority", new Object[]{ANALYZER_PRIORITY, it.getMetadata().get(ANALYZER_KEY), e});
            return Integer.MAX_VALUE;
        }
    };
    static final Predicate<ServiceInstance> SUPPORT_INDEX = it -> {
        try {
            return Boolean.valueOf((String)it.getMetadata().get(ANALYZER_INDEX));
        }
        catch (Exception e) {
            LOGGER.warn("Incorrect specification of tag '{}' for service '{}'. Using 'false' as default value.", new Object[]{ANALYZER_INDEX, it.getMetadata().get(ANALYZER_KEY), e});
            return false;
        }
    };
}

