/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;

public class ProjectAuthority
implements GrantedAuthority {
    private final String project;
    private final String projectRole;

    public ProjectAuthority(String project, String projectRole) {
        this.project = project;
        this.projectRole = projectRole;
    }

    public String getProject() {
        return this.project;
    }

    public String getProjectRole() {
        return this.projectRole;
    }

    public String getAuthority() {
        return "PROJECT_" + this.project + "_" + this.projectRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectAuthority that = (ProjectAuthority)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.projectRole, that.projectRole);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.projectRole);
    }
}

