/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.log4j.appender;

import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.log4j.appender.Util;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import rp.com.google.common.base.Function;

public class ReportPortalAppender
extends AppenderSkeleton {
    protected void append(final LoggingEvent event) {
        if (null == event.getMessage()) {
            return;
        }
        if (Util.isInternal(event.getLoggerName())) {
            return;
        }
        ReportPortal.emitLog((Function)new Function<String, SaveLogRQ>(){

            public SaveLogRQ apply(String itemId) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setLevel(event.getLevel().toString());
                rq.setLogTime(new Date(event.getTimeStamp()));
                rq.setTestItemId(itemId);
                String logMessage = null;
                try {
                    ReportPortalMessage message = null;
                    StringBuilder throwable = new StringBuilder();
                    if (null != event.getThrowableInformation()) {
                        for (String oneLine : event.getThrowableStrRep()) {
                            throwable.append(oneLine);
                        }
                    }
                    if (event.getMessage() instanceof ReportPortalMessage) {
                        message = (ReportPortalMessage)event.getMessage();
                    } else if (event.getMessage() instanceof File) {
                        message = new ReportPortalMessage((File)event.getMessage(), "Binary data reported");
                    } else if (event.getMessage() instanceof String && Util.MESSAGE_PARSER.supports((String)event.getMessage())) {
                        message = Util.MESSAGE_PARSER.parse((String)event.getMessage());
                    }
                    if (null != message) {
                        logMessage = message.getMessage();
                        SaveLogRQ.File file = new SaveLogRQ.File();
                        file.setContentType(message.getData().getMediaType());
                        file.setContent(message.getData().read());
                        file.setName(UUID.randomUUID().toString());
                        rq.setFile(file);
                    } else {
                        logMessage = ReportPortalAppender.this.layout == null ? event.getRenderedMessage() : ReportPortalAppender.this.layout.format(event).concat(throwable.toString());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                rq.setMessage(logMessage);
                return rq;
            }
        });
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }
}

