/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.widget;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ContentParameters {
    @NotNull
    @JsonProperty(value="type", required=true)
    @ApiModelProperty(required=true, allowableValues="line_chart, column_chart, bar_chart, combine_pie_chart, trends_chart, not_passed_chart, cases_trend_chart, table, activity_panel, statistics_panel, unique_bug_table, bug_trend, launches_comparison_chart, launches_duration_chart, launches_table")
    private String type;
    @NotNull
    @JsonProperty(value="gadget", required=true)
    @ApiModelProperty(required=true, allowableValues="old_line_chart, investigated_trend, launch_statistics, statistic_trend, cases_trend, not_passed, overall_statistics, unique_bug_table, bug_trend, activity_stream, launches_comparison_chart, launches_duration_chart, launches_table, most_failed_test_cases")
    private String gadget;
    @JsonProperty(value="metadata_fields")
    private List<String> metadataFields;
    @JsonProperty(value="content_fields", required=true)
    private List<String> contentFields;
    @NotNull
    @Min(value=1L)
    @Max(value=150L)
    @JsonProperty(value="itemsCount", required=true)
    private int itemsCount;
    @JsonProperty(value="widgetOptions")
    private Map<String, List<String>> widgetOptions;

    public Map<String, List<String>> getWidgetOptions() {
        return this.widgetOptions;
    }

    public void setWidgetOptions(Map<String, List<String>> widgetOptions) {
        this.widgetOptions = widgetOptions;
    }

    public int getItemsCount() {
        return this.itemsCount;
    }

    public void setItemsCount(int itemsCount) {
        this.itemsCount = itemsCount;
    }

    public List<String> getContentFields() {
        return this.contentFields;
    }

    public void setContentFields(List<String> contentFields) {
        this.contentFields = contentFields;
    }

    public List<String> getMetadataFields() {
        return this.metadataFields;
    }

    public void setMetadataFields(List<String> metadataFields) {
        this.metadataFields = metadataFields;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getGadget() {
        return this.gadget;
    }

    public void setGadget(String value) {
        this.gadget = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentFields == null ? 0 : this.contentFields.hashCode());
        result = 31 * result + (this.metadataFields == null ? 0 : this.metadataFields.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentParameters other = (ContentParameters)obj;
        if (this.contentFields == null ? other.contentFields != null : !this.contentFields.equals(other.contentFields)) {
            return false;
        }
        if (this.metadataFields == null ? other.metadataFields != null : !this.metadataFields.equals(other.metadataFields)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContentParameters{");
        sb.append("type='").append(this.type).append('\'');
        sb.append(", gadget='").append(this.gadget).append('\'');
        sb.append(", metadataFields=").append(this.metadataFields);
        sb.append(", contentFields=").append(this.contentFields);
        sb.append('}');
        return sb.toString();
    }
}

