/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.impl.Decompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CharDecompressor
implements Decompressor {
    static final CharDecompressor INSTANCE = new CharDecompressor();
    private static final Logger LOGGER = LoggerFactory.getLogger(CharDecompressor.class);

    private CharDecompressor() {
    }

    @Override
    public byte[] decompressRow(int offset, int length, int resultLength, byte[] page) {
        byte[] resultByteArray = new byte[resultLength];
        int currentResultArrayIndex = 0;
        block11: for (int currentByteIndex = 0; currentByteIndex < length; ++currentByteIndex) {
            int controlByte = page[offset + currentByteIndex] & 0xF0;
            int endOfFirstByte = page[offset + currentByteIndex] & 0xF;
            switch (controlByte) {
                case 0: 
                case 16: 
                case 32: 
                case 48: {
                    if (currentByteIndex == length - 1) continue block11;
                    int countOfBytesToCopy = (page[offset + currentByteIndex + 1] & 0xFF) + 64 + page[offset + currentByteIndex] * 256;
                    System.arraycopy(page, offset + currentByteIndex + 2, resultByteArray, currentResultArrayIndex, countOfBytesToCopy);
                    currentByteIndex += countOfBytesToCopy + 1;
                    currentResultArrayIndex += countOfBytesToCopy;
                    continue block11;
                }
                case 64: {
                    int i;
                    int copyCounter = endOfFirstByte * 16 + (page[offset + currentByteIndex + 1] & 0xFF);
                    for (i = 0; i < copyCounter + 18; ++i) {
                        resultByteArray[currentResultArrayIndex++] = page[offset + currentByteIndex + 2];
                    }
                    currentByteIndex += 2;
                    continue block11;
                }
                case 96: {
                    int i;
                    for (i = 0; i < endOfFirstByte * 256 + (page[offset + currentByteIndex + 1] & 0xFF) + 17; ++i) {
                        resultByteArray[currentResultArrayIndex++] = 32;
                    }
                    ++currentByteIndex;
                    continue block11;
                }
                case 112: {
                    int i;
                    for (i = 0; i < endOfFirstByte * 256 + (page[offset + currentByteIndex + 1] & 0xFF) + 17; ++i) {
                        resultByteArray[currentResultArrayIndex++] = 0;
                    }
                    ++currentByteIndex;
                    continue block11;
                }
                case 128: 
                case 144: 
                case 160: 
                case 176: {
                    int countOfBytesToCopy = Math.min(endOfFirstByte + 1 + (controlByte - 128), length - (currentByteIndex + 1));
                    System.arraycopy(page, offset + currentByteIndex + 1, resultByteArray, currentResultArrayIndex, countOfBytesToCopy);
                    currentByteIndex += countOfBytesToCopy;
                    currentResultArrayIndex += countOfBytesToCopy;
                    continue block11;
                }
                case 192: {
                    int i;
                    for (i = 0; i < endOfFirstByte + 3; ++i) {
                        resultByteArray[currentResultArrayIndex++] = page[offset + currentByteIndex + 1];
                    }
                    ++currentByteIndex;
                    continue block11;
                }
                case 208: {
                    int i;
                    for (i = 0; i < endOfFirstByte + 2; ++i) {
                        resultByteArray[currentResultArrayIndex++] = 64;
                    }
                    continue block11;
                }
                case 224: {
                    int i;
                    for (i = 0; i < endOfFirstByte + 2; ++i) {
                        resultByteArray[currentResultArrayIndex++] = 32;
                    }
                    continue block11;
                }
                case 240: {
                    int i;
                    for (i = 0; i < endOfFirstByte + 2; ++i) {
                        resultByteArray[currentResultArrayIndex++] = 0;
                    }
                    continue block11;
                }
                default: {
                    LOGGER.error("Error control byte: {}", (Object)controlByte);
                }
            }
        }
        return resultByteArray;
    }
}

