/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.CSVDataWriter;
import com.epam.parso.Column;
import com.epam.parso.impl.AbstractCSVWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CSVDataWriterImpl
extends AbstractCSVWriter
implements CSVDataWriter {
    private static final int ROUNDING_LENGTH = 13;
    private static final int ACCURACY = 15;
    private static final String DOUBLE_INFINITY_STRING = "Infinity";
    private static final String HOURS_OUTPUT_FORMAT = "%02d";
    private static final String MINUTES_OUTPUT_FORMAT = "%02d";
    private static final String SECONDS_OUTPUT_FORMAT = "%02d";
    private static final String TIME_DELIMETER = ":";
    private static final String DATE_FORMAT_YYMMDD = "YYMMDD";
    private static final String DATE_FORMAT_MMDDYY = "MMDDYY";
    private static final String DATE_FORMAT_DDMMYY = "DDMMYY";
    private static final String DATE_FORMAT_E8601DA = "E8601DA";
    private static final String DATE_FORMAT_E8601DT = "E8601DT";
    private static final String DATE_FORMAT = "DATE";
    private static final String DATE_TIME_FORMAT = "DATETIME";
    private static final List<String> TIME_FORMAT_STRINGS = Arrays.asList("TIME", "HHMM");
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final String ENCODING = "CP1252";
    private static final Map<String, String> DATE_OUTPUT_FORMAT_STRINGS;

    public CSVDataWriterImpl(Writer writer) {
        super(writer);
    }

    public CSVDataWriterImpl(Writer writer, String delimiter) {
        super(writer, delimiter);
    }

    public CSVDataWriterImpl(Writer writer, String delimiter, String endline) {
        super(writer, delimiter, endline);
    }

    private static String convertDateElementToString(Date currentDate, String format) {
        String valueToPrint = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_OUTPUT_FORMAT_STRINGS.get(format));
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (currentDate.getTime() != 0L) {
            valueToPrint = dateFormat.format(currentDate.getTime());
        }
        return valueToPrint;
    }

    private static String convertTimeElementToString(Long secondsFromMidnight) {
        return String.format("%02d", secondsFromMidnight / 60L / 60L) + TIME_DELIMETER + String.format("%02d", secondsFromMidnight / 60L % 60L) + TIME_DELIMETER + String.format("%02d", secondsFromMidnight % 60L);
    }

    private static String convertDoubleElementToString(Double value) {
        String valueToPrint = String.valueOf(value);
        if (valueToPrint.length() > 13) {
            int lengthBeforeDot = (int)Math.ceil(Math.log10(Math.abs(value)));
            BigDecimal bigDecimal = new BigDecimal(value);
            bigDecimal = bigDecimal.setScale(15 - lengthBeforeDot, 4);
            valueToPrint = String.valueOf(bigDecimal.doubleValue());
        }
        valueToPrint = CSVDataWriterImpl.trimZerosFromEnd(valueToPrint);
        return valueToPrint;
    }

    private static String trimZerosFromEnd(String string) {
        return string.contains(".") ? string.replaceAll("0*$", "").replaceAll("\\.$", "") : string;
    }

    @Override
    public void writeRow(List<Column> columns, Object[] row) throws IOException {
        if (row == null) {
            return;
        }
        Writer writer = this.getWriter();
        for (int currentColumnIndex = 0; currentColumnIndex < columns.size(); ++currentColumnIndex) {
            if (row[currentColumnIndex] != null) {
                if (row[currentColumnIndex].getClass().getName().compareTo(new byte[0].getClass().getName()) == 0) {
                    CSVDataWriterImpl.checkSurroundByQuotesAndWrite(writer, this.getDelimiter(), new String((byte[])row[currentColumnIndex], ENCODING));
                } else {
                    this.processEntry(columns, row, currentColumnIndex);
                }
            }
            if (currentColumnIndex == columns.size() - 1) continue;
            writer.write(this.getDelimiter());
        }
        writer.write(this.getEndline());
        writer.flush();
    }

    @Override
    public void writeRowsArray(List<Column> columns, Object[][] rows) throws IOException {
        for (Object[] currentRow : rows) {
            if (currentRow == null) break;
            this.writeRow(columns, currentRow);
        }
    }

    @Override
    public void writeColumnNames(List<Column> columns) throws IOException {
        Writer writer = this.getWriter();
        for (int i = 0; i < columns.size(); ++i) {
            CSVDataWriterImpl.checkSurroundByQuotesAndWrite(writer, this.getDelimiter(), columns.get(i).getName());
            if (i == columns.size() - 1) continue;
            writer.write(this.getDelimiter());
        }
        writer.write(this.getEndline());
        writer.flush();
    }

    private void processEntry(List<Column> columns, Object[] row, int currentColumnIndex) throws IOException {
        if (!String.valueOf(row[currentColumnIndex]).contains(DOUBLE_INFINITY_STRING)) {
            String valueToPrint;
            if (row[currentColumnIndex].getClass() == Date.class) {
                valueToPrint = CSVDataWriterImpl.convertDateElementToString((Date)row[currentColumnIndex], columns.get(currentColumnIndex).getFormat());
            } else if (TIME_FORMAT_STRINGS.contains(columns.get(currentColumnIndex).getFormat())) {
                valueToPrint = CSVDataWriterImpl.convertTimeElementToString((Long)row[currentColumnIndex]);
            } else {
                valueToPrint = String.valueOf(row[currentColumnIndex]);
                if (row[currentColumnIndex].getClass() == Double.class) {
                    valueToPrint = CSVDataWriterImpl.convertDoubleElementToString((Double)row[currentColumnIndex]);
                }
            }
            CSVDataWriterImpl.checkSurroundByQuotesAndWrite(this.getWriter(), this.getDelimiter(), valueToPrint);
        }
    }

    static {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        tmpMap.put(DATE_FORMAT_YYMMDD, "yyyy-MM-dd");
        tmpMap.put(DATE_FORMAT_MMDDYY, "MM/dd/yyyy");
        tmpMap.put(DATE_FORMAT_DDMMYY, "dd/MM/yyyy");
        tmpMap.put(DATE_FORMAT, "ddMMMyyyy");
        tmpMap.put(DATE_TIME_FORMAT, "yyyy-MM-dd HH:mm:ss");
        tmpMap.put(DATE_FORMAT_E8601DA, "yyyy-MM-dd");
        tmpMap.put(DATE_FORMAT_E8601DT, "yyyy-MM-dd'T'HH:mm:ss");
        DATE_OUTPUT_FORMAT_STRINGS = Collections.synchronizedMap(tmpMap);
    }
}

