/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.utils;

import com.epam.healenium.SelfHealingEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class ResourceReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readResource(String classpath, Function<Stream<String>, T> function) {
        ClassLoader classLoader = SelfHealingEngine.class.getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream(classpath);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(stream)));
            Stream<String> t = function.apply(reader.lines());
            return (T)t;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize engine", e);
        }
    }
}

