/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.service.impl;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.service.HealingElementsService;
import com.epam.healenium.service.impl.AbstractHealingServiceImpl;
import com.epam.healenium.treecomparing.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingElementsServiceImpl
extends AbstractHealingServiceImpl
implements HealingElementsService {
    private static final Logger log = LoggerFactory.getLogger(HealingElementsServiceImpl.class);

    public HealingElementsServiceImpl(SelfHealingEngine engine) {
        super(engine);
    }

    @Override
    public List<WebElement> heal(PageAwareBy pageBy, List<WebElement> pageElements) {
        Optional<LastHealingDataDto> lastHealingDataDto = this.getLastHealingDataDto(pageBy);
        if (!lastHealingDataDto.isPresent() || lastHealingDataDto.get().getPaths().isEmpty()) {
            return pageElements;
        }
        ArrayList<List<Node>> lastValidPath = new ArrayList<List<Node>>(lastHealingDataDto.map(LastHealingDataDto::getPaths).get());
        if (lastValidPath.isEmpty() && !pageElements.isEmpty()) {
            this.engine.saveElements(pageBy, pageElements);
            return pageElements;
        }
        return this.healAndSave(pageBy, pageElements, lastValidPath, lastHealingDataDto);
    }

    private List<WebElement> healAndSave(PageAwareBy pageBy, List<WebElement> elementsFromPage, List<List<Node>> nodesFromDb, Optional<LastHealingDataDto> lastHealingDataDto) {
        HashMap<WebElement, List<Node>> elementToNodeFromPage = new HashMap<WebElement, List<Node>>();
        ArrayList nodesFromDbToDelete = new ArrayList();
        elementsFromPage.forEach(e -> elementToNodeFromPage.put((WebElement)e, (List<Node>)new ArrayList<Node>(this.engine.getNodePath((WebElement)e))));
        nodesFromDb.forEach(node -> elementToNodeFromPage.entrySet().removeIf(entry -> {
            if (node.equals(entry.getValue())) {
                nodesFromDbToDelete.add(node);
                return true;
            }
            return false;
        }));
        nodesFromDb.removeAll(nodesFromDbToDelete);
        List<WebElement> healedElements = nodesFromDb.stream().map(nodes -> {
            log.warn("Failed to find an element using locator {}\nTrying to heal...", (Object)pageBy.getBy());
            return this.healLocator(pageBy, (List<Node>)nodes, lastHealingDataDto).orElse(null);
        }).map(arg_0 -> ((WebDriver)this.driver).findElement(arg_0)).collect(Collectors.toList());
        this.addHealedElements(elementsFromPage, elementToNodeFromPage, healedElements);
        if (!elementToNodeFromPage.isEmpty()) {
            List<List<Node>> nodesToSave = lastHealingDataDto.get().getPaths();
            nodesToSave.addAll(elementToNodeFromPage.values());
            this.engine.saveNodes(pageBy, nodesToSave);
        }
        return elementsFromPage;
    }

    private void addHealedElements(List<WebElement> elementsFromPage, Map<WebElement, List<Node>> elementToNodeFromPage, List<WebElement> healedElements) {
        if (!healedElements.isEmpty()) {
            elementsFromPage.addAll(healedElements);
            List<List> healedNodes = healedElements.stream().map(this.engine::getNodePath).collect(Collectors.toList());
            if (!elementToNodeFromPage.isEmpty()) {
                healedNodes.forEach(healedNode -> elementToNodeFromPage.entrySet().removeIf(entry -> healedNode.equals(entry.getValue())));
            }
        }
    }
}

