/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.service.impl;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.model.HealeniumSelectorImitatorDto;
import com.epam.healenium.model.HealingCandidateDto;
import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.MetricsDto;
import com.epam.healenium.model.RequestDto;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealingServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractHealingServiceImpl.class);
    protected final SelfHealingEngine engine;
    protected final WebDriver driver;

    public AbstractHealingServiceImpl(SelfHealingEngine engine) {
        this.engine = engine;
        this.driver = engine.getWebDriver();
    }

    protected Optional<By> healLocator(PageAwareBy pageBy, List<Node> paths, Optional<LastHealingDataDto> lastHealingDataDto) {
        Optional<Scored<By>> result;
        String pageContent = this.pageSource();
        Locator userLocator = this.engine.getClient().getMapper().byToLocator(pageBy.getBy());
        MetricsDto metricsDto = new MetricsDto().setCurrentDom(pageContent).setUserSelector(userLocator).setPreviousSuccessfulDom(lastHealingDataDto.get().getPageContent());
        List<Scored<By>> choices = this.engine.findNewLocations(pageContent, paths, metricsDto);
        HealingCandidateDto mainHealingCandidate = metricsDto.getMainHealingCandidate();
        if (mainHealingCandidate != null) {
            this.imitateMainCandidate(userLocator, mainHealingCandidate, choices);
        }
        if (!(result = choices.stream().findFirst()).isPresent()) {
            log.warn("New element locators have not been found");
            double scoreCap = this.engine.getScoreCap();
            log.warn("Score property={} is bigger than healing's locator score", (Object)scoreCap);
        } else {
            this.saveHealedElement(pageBy, pageContent, metricsDto, choices, result);
        }
        return result.map(Scored::getValue);
    }

    private void saveHealedElement(PageAwareBy pageBy, String pageContent, MetricsDto metricsDto, List<Scored<By>> choices, Optional<Scored<By>> result) {
        Scored<By> healed = result.get();
        log.warn("Using healed locator: {}", result);
        byte[] screenshot = this.captureScreen(healed);
        metricsDto.setHealedSelector(this.engine.getClient().getMapper().byToLocator((By)healed.getValue()));
        String healingTime = this.engine.getHealingTime();
        RequestDto requestDto = this.engine.getClient().getMapper().buildDto(pageBy.getBy(), pageContent, choices, healed, screenshot);
        this.engine.getClient().healRequest(requestDto, screenshot, healingTime, metricsDto);
    }

    protected Optional<LastHealingDataDto> getLastHealingDataDto(PageAwareBy pageBy) {
        return this.engine.getClient().getLastHealingData(pageBy.getBy());
    }

    protected void imitateMainCandidate(Locator userLocator, HealingCandidateDto mainHealingCandidate, List<Scored<By>> choices) {
        Node targetNode = mainHealingCandidate.getNode();
        Double score = mainHealingCandidate.getScore();
        if (targetNode != null) {
            HealeniumSelectorImitatorDto healeniumSelectorImitator = new HealeniumSelectorImitatorDto().setUserSelector(userLocator).setTargetNode(targetNode);
            List<Locator> imitatedLocators = this.engine.getClient().imitate(healeniumSelectorImitator);
            this.engine.toLocator(imitatedLocators, score).ifPresent(by -> {
                choices.remove(0);
                choices.add(0, (Scored<By>)by);
            });
        }
    }

    protected byte[] captureScreen(Scored<By> byScored) {
        WebElement element = this.driver.findElement((By)byScored.getValue());
        if (this.engine.isHealingBacklighted()) {
            JavascriptExecutor jse = (JavascriptExecutor)this.driver;
            jse.executeScript("arguments[0].style.border='3px solid red'", new Object[]{element});
        }
        return (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
    }

    protected String pageSource() {
        if (this.driver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.driver).executeScript("return document.body.outerHTML;", new Object[0]).toString();
        }
        return this.driver.getPageSource();
    }
}

