/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.handlers.proxy;

import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.handlers.proxy.BaseHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingProxyInvocationHandler
extends BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(SelfHealingProxyInvocationHandler.class);

    public SelfHealingProxyInvocationHandler(SelfHealingEngine engine) {
        super(engine);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            ClassLoader loader = this.driver.getClass().getClassLoader();
            switch (method.getName()) {
                case "findElement": {
                    WebElement element = this.findElement((By)args[0]);
                    return Optional.ofNullable(element).map(it -> this.wrapElement((WebElement)it, loader)).orElse(null);
                }
                case "findElements": {
                    List<WebElement> elements = this.findElements((By)args[0]);
                    return elements.stream().map(it -> this.wrapElement((WebElement)it, loader)).collect(Collectors.toList());
                }
                case "getCurrentEngine": {
                    return this.engine;
                }
                case "getDelegate": {
                    return this.driver;
                }
                case "switchTo": {
                    WebDriver.TargetLocator switched = (WebDriver.TargetLocator)method.invoke((Object)this.driver, args);
                    return this.wrapTarget(switched, loader);
                }
            }
            return method.invoke((Object)this.driver, args);
        }
        catch (Exception ex) {
            throw ex.getCause();
        }
    }
}

