/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.handlers.proxy;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.handlers.proxy.TargetLocatorProxyInvocationHandler;
import com.epam.healenium.handlers.proxy.WebElementProxyHandler;
import com.epam.healenium.service.HealingService;
import com.epam.healenium.service.impl.HealingServiceImpl;
import com.epam.healenium.utils.ProxyFactory;
import com.typesafe.config.Config;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseHandler.class);
    protected final SelfHealingEngine engine;
    protected final WebDriver driver;
    private final Config config;
    private final HealingService healingService;

    public BaseHandler(SelfHealingEngine engine) {
        this.engine = engine;
        this.driver = engine.getWebDriver();
        this.config = engine.getConfig();
        this.healingService = new HealingServiceImpl(engine);
    }

    protected WebElement findElement(By by) {
        try {
            PageAwareBy pageBy = this.awareBy(by);
            By inner = pageBy.getBy();
            if (this.engine.isHealingEnabled()) {
                return this.lookUp(pageBy);
            }
            return this.driver.findElement(inner);
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to find element using " + by.toString(), (Throwable)ex);
        }
    }

    protected List<WebElement> findElements(By by) {
        try {
            PageAwareBy pageBy = this.awareBy(by);
            By inner = pageBy.getBy();
            if (this.engine.isHealingEnabled()) {
                return this.lookUpElements(pageBy);
            }
            return this.driver.findElements(inner);
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to find elements using " + by.toString(), (Throwable)ex);
        }
    }

    protected WebElement lookUp(PageAwareBy key) {
        try {
            WebElement element = this.driver.findElement(key.getBy());
            this.engine.savePath(key, Collections.singletonList(element));
            return element;
        }
        catch (NoSuchElementException e) {
            log.warn("Failed to find an element using locator {}\nReason: {}\nTrying to heal...", (Object)key.getBy().toString(), (Object)e.getMessage());
            return this.healingService.heal(key, e).orElseThrow(() -> e);
        }
    }

    protected List<WebElement> lookUpElements(PageAwareBy key) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        try {
            List pageElements = this.driver.findElements(key.getBy());
            if (pageElements.isEmpty()) {
                throw new NoSuchElementException("Failed to find pageElements");
            }
            return this.healingService.saveAndHealElements(key, pageElements, stackTrace);
        }
        catch (NoSuchElementException e) {
            log.warn("Failed to find an element using locator {}\nReason: {}\nTrying to heal...", (Object)key.getBy().toString(), (Object)e.getMessage());
            return this.healingService.healElements(key, stackTrace, e);
        }
    }

    protected PageAwareBy awareBy(By by) {
        return by instanceof PageAwareBy ? (PageAwareBy)by : PageAwareBy.by(this.driver.getTitle(), by);
    }

    protected WebElement wrapElement(WebElement element, ClassLoader loader) {
        WebElementProxyHandler elementProxyHandler = new WebElementProxyHandler(element, this.engine);
        return ProxyFactory.createWebElementProxy(loader, elementProxyHandler);
    }

    protected WebDriver.TargetLocator wrapTarget(WebDriver.TargetLocator locator, ClassLoader loader) {
        TargetLocatorProxyInvocationHandler handler = new TargetLocatorProxyInvocationHandler(locator, this.engine);
        return ProxyFactory.createTargetLocatorProxy(loader, handler);
    }

    public HealingService getHealingService() {
        return this.healingService;
    }
}

